

void renderGame(){
  
  if(screenShake>0.01){
    translate(random(-screenShake,screenShake),random(-screenShake,screenShake));
    screenShake-=0.1;
  }
  noTint();
  image(water,0,0);
  image(info_pane,0,scaledScrHeight-info_pane.height);
  noMouseOver = true;
  for(int i=0;i<areas.size();i++){
    Area a = areas.get(i);
    a.drawArea(!currentPlayer().hasUpgrade());
    noMouseOver = (a.mouseOver) ? false:noMouseOver;
  }
  
  for(int i=0;i<areas.size();i++){
    Area a = areas.get(i);
    a.drawUpgrades();
  }
  /*
  for(int i=0;i<areas.size();i++){
    Area a = areas.get(i);
    a.drawAreaText();
  }*/
  
  for (int i = anims.size()-1; i >= 0; i--) { // go through all the anims
    multiAnimObject _anim = (multiAnimObject) anims.get(i);
    _anim.display(_anim.xpos,_anim.ypos);
    
    if (_anim.finished) { // Items can be deleted with remove() from ArrayList.
      anims.remove(i);
    }
  }
  
  for (int i = popMessages.size()-1; i >= 0; i--) { // go through all the anims
    PopMessage _mes = (PopMessage) popMessages.get(i);
    _mes.display(_mes.xpos,_mes.ypos);
    
    if (_mes.finished) { // Items can be deleted with remove() from ArrayList.
      popMessages.remove(i);
    }
  }
  
  tint(250,250,200,25);
  image(glow,0,0);
  noTint(); 
  image(gui_bg,0,2);
  
  playerActions();
  playerPane();
  hasUpgrade();
  checkMusic();
}

void checkMusic(){
  if(song.isPlaying() == false && playMusic==true) {
   playSound("song");
  }
  if(playMusic==false){
    song.pause();
  }else{
    musicAt=song.position();
  }
}

void playerActions(){
    
  for(int i=0;i<players.size();i++){
    Player _p = players.get(i);
    _p.showGold();
    if(_p.id==playerTurn){_p.showActions(!currentPlayer().hasUpgrade());}
    
    if(_p.id==playerTurn){
      if(gameState==STATE_GAMEOVER){
        printShaded("EXIT",2*scaledScrWidth-42,2*scaledScrHeight-12);
      }else{
        if(_p.isHuman){
          endTurnButton.render();
          //printShaded("END TURN "+gameTurn,2*scaledScrWidth-42,2*scaledScrHeight-12);
        }else{
          printShaded("ENEMY TURN "+gameTurn,2*scaledScrWidth-42,2*scaledScrHeight-12);
        }
      }
    }
  }
}

void playerPane(){
  int _placer=0;
  int _atY=32;
  for(int i=0;i<players.size();i++){
    _placer=i;    
    image(player_pane,0,_atY+(_placer*16));
    tint(tintByOwner2(i+1,color(10)));
    image(player_pane_colorplate,0,_atY+(_placer*16));
    if(i+1==playerTurn){
      tint(220,210,200);
      image(player_pane_current,0,_atY+(_placer*16));
    }
    Player _p = players.get(i);
    if(_p.isAlive){
      printShaded("GOLD: "+_p.gold+"/"+getIncome(i+1),32,_atY*2+19+(_placer*32));
    }else{
      printShaded(" - DEAD -",32,_atY*2+19+(_placer*32));
    }
    if(_p.id==1 && level == 1){
      printShaded("SELECT",32,14*12);
      printShaded("ACTION",32,15*12);
      printShaded("BELOW,",32,16*12);
      printShaded("THEN",32,17*12);
      printShaded("ATTACK",32,18*12);
      printShaded("ADJACENT",32,19*12);
      printShaded("AREA",32,20*12);
      printShaded("|",32,22*12);
      printShaded("|",32,23*12);
      printShaded("\\/",32,24*12);
    }
    noTint();
  }
}
void hasUpgrade(){
  if(currentPlayer().hasUpgrade()){
    image(upgrade_pane,0,scaledScrHeight-info_pane.height);
    printShaded("CHOOSE UPGRADE:",int(scaledScrWidth*0.18),2*scaledScrHeight-12);
    int _btnCount=0;
    for(int _a=0;_a<currentPlayer().actions.size()-1;_a++){
      Action _action = currentPlayer().actions.get(_a);
      if(!_action.upgraded){
        _btnCount++;
        switch(_action.type){
          case 0:
            upgradeArmyButton.x1 = int( (scaledScrWidth*0.1) + (_btnCount*action_army.width*1.2) );
            upgradeArmyButton.update();
          break;
          case 1:
            upgradeFortButton.x1 = int( (scaledScrWidth*0.1) + (_btnCount*action_army.width*1.2) );
            upgradeFortButton.update();
          break;
          case 2:
            upgradeFleetButton.x1 = int( (scaledScrWidth*0.1) + (_btnCount*action_army.width*1.2) );
            upgradeFleetButton.update();
          break;
          case 3:
            upgradeTradeButton.x1 = int( (scaledScrWidth*0.1) + (_btnCount*action_army.width*1.2) );
            upgradeTradeButton.update();
          break;
          default:
          break;
        }
      }
    }
  }
}