class Player {
  String name;
  int id;
  PImage portrait;
  int gold;
  int startArea;
  boolean isAlive,isHuman;
  ArrayList <Action> actions;
  float aiIterations;
  float[] aiPreference=new float[5];
  float[] aiDiplomacy=new float[4];
  float aggression,uniFondness;
  float dominance;
  int research,maxUni;
  
  static final int upgradeCost = 10;
  
  Player (String _name, int _gold, int _startArea, int _id){
    name=_name;
    id=_id;
    portrait=loadImage("portrait"+id+".png");
    gold=_gold;
    isAlive=true;
    isHuman = (id<=humanPlayers);
    
    research=0;
    maxUni=int(random(0,5));
    uniFondness=random(1)+.5;
    aiIterations=20;//int(random(1))+3;
    
    aiDiplomacy[0] = 0.8;
    aiDiplomacy[1] = 0.8;
    aiDiplomacy[2] = 0.8;
    aiDiplomacy[3] = 0.8;
    startArea=_startArea;
    aggression=0;
    
    actions = new ArrayList<Action>();
    int _actionLimit = (level>5) ? 5 : level ;    
    for(int _i=0;_i<_actionLimit;_i++){ 
      actions.add(new Action(_i));
    }
    
 }  
 
 void setAIPreference(){
    aiPreference[0] = 0.8 + random(0.3);
    aiPreference[1] = 0.8 + random(0.2);
    aiPreference[2] = 0.8 + random(0.2);
    aiPreference[3] = 0.8 + random(0.2);
    aiPreference[4] = 0.8 + random(0.2);
 }
 
 void calcDominance(){
   float _controlled = 0;
   for (int i=0;i<areas.size();i++) {
      Area a = areas.get(i);
      if(a.ownedBy==id){
        _controlled += 1;
      }
   }
   dominance = _controlled/float(areas.size());
   if(dominance > 0.53){println("PLAYER",id,"IS DOMINATING!");}
 }

 boolean hasUpgrade() {
   //println("has upgrade? " + (research >= upgradeCost));
   Boolean _upgradeable=false;
   for(int _i=0;_i<actions.size()-1;_i++){ 
      if(!actions.get(_i).upgraded){_upgradeable=true;}
    }
   return (research >= upgradeCost && _upgradeable);
 }
 
 void upgrade(int type) {
   if (research < upgradeCost)
     return;
   if (actions.get(type).upgraded)
     return;
   research -= upgradeCost;
   actions.get(type).upgraded=true;
 }
 
 Boolean isActionUpgraded(int _withAction){
   Boolean _itIs=false;
   for(int i=0;i<constrain(actions.size()-1,0,4);i++){
     if(i == _withAction && actions.get(i).upgraded){_itIs=true;}
   }
   return _itIs;
 }
 
 void showActions(boolean canPressAction){
   for(int i=0;i<actions.size();i++){
    Action _a = actions.get(i);
      // todo make only one selectable at a time: _a.selected=false;
     _a.update(i,canPressAction);
   }
  if(gold*0.5>aiIterations){aiIterations=int(gold*0.5);}
  image(portrait,0,0);
  if(research>0){
    printShaded("RESEARCH: " + research, 32, 58);
  }
 }
 void showGold(){
   if(playerTurn==id){
     printShaded("GOLD: " + gold, 32, 83);
     noTint();
   }else{
     //scale(2);
     noTint();
   }
   if(!isAlive){
     tint(tintByOwner(id));
      image(dead, 0,32+16+(id-2)*(player_pane.height));
   }
 }
}