
class multiAnimObject {
  PImage spriteMap;
  PImage[][] images;
  float currentFrame, currentAnimation;
  float frame,animation;
  float pace;
  int xpos;
  int ypos;
  boolean finished = false;
  
  multiAnimObject(PImage sprMap, int sprWidth, int sprHeight, int mx, int my, float p, int _anim) { // initialize a new object. Why is the double initialization done? Compare count->imageCount to sprWidth is only sprWidth.
    spriteMap = sprMap;

    xpos = mx;
    ypos = my;
    pace = p;

    animation = spriteMap.height/sprHeight;
    frame = spriteMap.width/sprWidth;
    images = new PImage[int(animation)][int(frame)];
    currentFrame=0;
    currentAnimation=_anim;
    for (int a = 0; a < animation; a++) {
      for (int i = 0; i < frame; i++) {
        //println("a: "+ a + ", i: " + i);
        images[a][i] = createImage(sprWidth, sprHeight, ARGB);
        images[a][i].copy(spriteMap,i*sprWidth,a*sprHeight,sprWidth,sprHeight,0,0,sprWidth,sprHeight); 
      }
    }
  }
  
  multiAnimObject setDelay(float delay) {
    currentFrame = -delay;
    return this;
  }

  void display(float xpos, float ypos) {
    currentFrame = (currentFrame+pace);
    if (int(currentFrame) >= frame){
      finished=true;
    } else {
      if (currentFrame < 0) {
        return;
      }
      image(images[int(currentAnimation)][int(currentFrame)], xpos, ypos);
    }
  }
}
class PopMessage {
  String message;
  int time;
  float pace,currentTime;
  int xpos;
  int ypos;
  boolean finished = false;
  
  PopMessage(String _mes, int mx, int my, float _pace, int _time) { // initialize a new object. Why is the double initialization done? Compare count->imageCount to sprWidth is only sprWidth.
    message = _mes;

    xpos = mx;
    ypos = my;
    pace = _pace;
    time = _time;
    currentTime=0;
  }
  
  PopMessage setDelay(float delay) {
    currentTime = -delay;
    return this;
  }

  void display(float xpos, float ypos) {
    currentTime = (currentTime+pace);
    if (int(currentTime) >= time){
      finished=true;
    } else {
      if (currentTime < 0) {
        return;
      }
      printShadedFade(message,int(xpos),int(ypos-currentTime*0.5), int(time - currentTime));
    }
  }
}