void generatorState(){
 
      if(loadMap){
        //dont run generator
        runGenerator=false;
        println("CREATING AREA OBJECTS");
        createWorld();
        println("INITIALIZING PLAYERS");
        
        initPlayers();
        
        println("GAME STATE SET TO GAME");
        println("START PLAYER", playerTurn+"'S TURN");
        pauseTimer=millis()+3000;
        if(autoRun){pauseTimer=millis()+1000;}
        gameState=STATE_MAPSTART;
        
       if(autoRun){
          Player _p =players.get(0);
          _p.isHuman=false;
          aiSpeed=150;
        }
      }else{ //run generator
        if(runOnce){
          println("INITIALIZING NEW MAP WITH", genAreas,"AREAS");
          initMap();
          println("EXPANDING MAP AREAS");
          startMap();
          
          runOnce=false;
        }else{
          if(runGenerator){
            iterations++;
            generateMap();
            image(worldMap,0,0);
            text(genLimits[2]+1-iterations,15,10);
            if(iterations>genLimits[2]){
              println("MAP GENERATION COMPLETE");
              runGenerator=false;
              println("CREATING AREA OBJECTS");
              createWorld();
              println("INITIALIZING PLAYERS");
              initPlayers();
              println("GAME STATE SET TO GAME");
              
              println("START PLAYER", playerTurn+"'S TURN");
              gameState=STATE_GAME;
              aiDelay=millis()+100;
            }
          }
        }
    } 
  
  
}

void createWorld(){
  color alphaColor = worldMap.get(0,0);
  color currColor = color(0);
  for(int _y=0;_y<worldMap.height-1;_y++){
    for(int _x=0;_x<worldMap.width-1;_x++){
      currColor=worldMap.get(_x,_y);
      if (currColor!=alphaColor){
        //found land. Make area!
        boolean newArea = true;
        for(int i = areas.size()-1;i>=0;i--){// check to see if new land
          Area _area = areas.get(i);
          if(currColor == _area.areaColor){
            newArea=false;
          }
        }
        if(newArea==true) {
          makeArea(currColor,_x,_y);
        }
      } else { // in the water
      int landProximity=countSurrounding(worldMap, _x, _y, alphaColor);
        if(landProximity < 9 && _y > 1){
          color _cTweak = color(red(water.get(_x,_y))+landProximity,green(water.get(_x,_y))+landProximity*2,blue(water.get(_x,_y))+landProximity*3);
          water.set(_x,_y,_cTweak);
        }
      }
    }
  }
  // After all areas are created, find their neighbors.
  for(int i=0;i<areas.size();i++){
    Area a = areas.get(i);
    a.findNeighbors();
  }
  for(int i=0;i<areas.size();i++){
    Area a = areas.get(i);
    a.findChokePoints();
  }
  //water.filter(BLUR,1); // could be used to make a nicer shoreline, if texture was added afterwards.
  println("FINAL AREA COUNT IS",areas.size());

}

void makeArea(color _col,int _xx,int _yy){
  color _c = _col;
  color _moc = color(245);
  int _x1=_xx;
  int _y1=_yy;
  int _x2=_xx+1;
  int _y2=_yy+1;
  
  for(int _y=0;_y<worldMap.height-1;_y++){
    for(int _x=0;_x<worldMap.width-1;_x++){
      if (worldMap.get(_x,_y)==_c) { //adjust bounds
        _x1 = (_x < _x1) ? _x : _x1 ; 
        _x2 = (_x > _x2) ? _x : _x2 ;
        _y1 = (_y < _y1) ? _y : _y1 ; 
        _y2 = (_y > _y2) ? _y : _y2 ;
      }
    }
  }
  PImage _im = createImage(_x2-_x1+2,_y2-_y1+2,RGB); //Create area image;
  PImage _moim = createImage(_x2-_x1+2,_y2-_y1+2,RGB);
  //println("Bounds:",_x1,_y1,_x2,_y2);
  //copy area to temp image and crop
  // FIND BUG!!
  for(int _y=0;_y<_im.height-1;_y++){
    for(int _x=0;_x<_im.width-1;_x++){
      if(worldMap.get(_x1+_x,_y1+_y)==_c) {
        _im.set(_x+1,_y+1,_c);
        _moim.set(_x+1,_y+1,_moc);
      }else{
        _im.set(_x+1,_y+1,color(0));
        _moim.set(_x+1,_y+1,color(0));
      }
    }
  }
  
  areas.add(new Area(_x1-1,_y1-1,_x2+1,_y2+1, renderArea(_im), _moim, _c, areas.size()));
}

int countSurrounding(PImage _img, int xx, int yy, color compareWith){
  int count=0;
  for(int tx = -1;tx<2;tx++){
    for(int ty = -1;ty<2;ty++){
      if(inImg(_img,xx+tx,yy+ty)){
        if(_img.get(xx+tx,yy+ty) == compareWith){
          count++;
        }
      }
    }
  }
  return count;
}
boolean inImg(PImage _img,int _x,int _y){
  boolean in=false;
  if(_x >= 0 && _y >= 0 && _x <= _img.width  && _y <= _img.height ){
    in=true;
  }
  return in;
}

color getSumOfSurrounding(PImage _baseImg,int _x,int _y){
  return (_baseImg.get(_x,_y));
}

//---------------------------------------
void initPlayers(){
  noPlayers=(level>3) ? 4 : level+1 ;
  while(playerCount<noPlayers){
    Area _a = areas.get(int(random(areas.size())));
    if(_a.ownedBy==0){
      _a.ownedBy=playerCount+1;
      _a.fort=true;
      //_a.income+=1;
      playerCount++;
      players.add(new Player("Player " + _a.ownedBy, int(random(3,7)), _a.id,playerCount));
      println("PLAYER",_a.ownedBy,"CREATED.");
      println("PLAYER",_a.ownedBy,"'S STARTING AREA IS",_a.name);
    }
  }
  randomSeed(int(random(100)));
  for(int _i = 0;_i<players.size();_i++){
    Player _p = players.get(_i);
    _p.setAIPreference();
  }
  if(level==1){
    for(int i = 0;i< areas.size();i++){
      Area _a = areas.get(i);
      _a.fort=false;
    }
  }
}

void startMap(){
  worldMap=createImage(scaledScrWidth,scaledScrHeight,RGB);
  int _box=7;
  for(int _my=0;_my<gridHeight;_my++){
    for(int _mx=0;_mx<gridWidth;_mx++){
      color _mmcol=miniMap.get(_mx,_my);
      if(_mmcol!=color(0)){
        //println(_mmcol);
        int ex=margin +margin -2 + _mx*22 + int(random(-_box,_box));
        int ey=(margin-9) +_my*17 + int(random(-_box,_box));
        for(int i=0;i<4;i++){
          int _xr1=int(random(-12,-5));
          int _yr1=int(random(-10,-4));
          int _xr=int(random(5,12));
          int _yr=int(random(4,10));
          
          for(int _y=_yr1;_y<_yr;_y++){
            for(int _x=_yr1;_x<_xr;_x++){
              worldMap.set(ex+_x,ey+_y,_mmcol);
            }
          }
        }
      }
    }
  }
}

void initMap(){ 
  for(int _my=0;_my<gridHeight;_my++){
    for(int _mx=0;_mx<gridWidth;_mx++){
      miniMap.set(_mx,_my,color(int(random(1)*50)+145,int(random(1)*55)+155,int(random(1)*40)+140));
    }
  }
  int _aCount=0;
  while (_aCount!=genAreas){
    _aCount=0;
    for(int _my=0;_my<gridHeight;_my++){
      for(int _mx=0;_mx<gridWidth;_mx++){
        _aCount = (miniMap.get(_mx,_my) == color(0)) ? _aCount : _aCount+1;
      }
    }
    int XX=int(random(gridWidth+1));
    int YY=int(random(gridHeight+1));
    if(_aCount<genAreas){
      miniMap.set(XX,YY,color(int(random(1)*150)+100,int(random(1)*150)+100,int(random(1)*150)+100));
    } else{
      miniMap.set(XX,YY,color(0)); // maybe add bias to make "holes" toward edges.
    }
  }
}

void generateMap(){
  int _N,_xx,_yy;
  
  color _doCol;
  color _watCol=worldMap.get(0,0);
  for(int i = 0;i<450;i++){
    for(int _my=0;_my<gridHeight;_my++){
      for(int _mx=0;_mx<gridWidth;_mx++){
        _xx=int(random(1,scaledScrWidth-1));
        _yy=int(random(1,scaledScrHeight-1));
        _doCol = miniMap.get(_mx,_my);
        if(_doCol!=color(0)){
          _N=countSurrounding(worldMap,_xx,_yy,_doCol);
          if(_N>random(1,3)){
            if(worldMap.get(_xx,_yy) == _watCol){
              worldMap.set(_xx,_yy,_doCol);
            }
          }
        }
      }
    }
  }
  plugCount++;
  if(plugCount>genLimits[0]){
    println("PLUGGING HOLES");
    plugCount=0;
    for(int _my=0;_my<scaledScrHeight;_my++){
        for(int _mx=0;_mx<scaledScrWidth;_mx++){
          //find singles and plug.
          
          int _countBub=countSurrounding(worldMap,_mx,_my,_watCol);
          if(worldMap.get(_mx,_my) == _watCol && _countBub == 1){
            worldMap.set(_mx,_my,worldMap.get(_mx+1,_my));
          }
        }
    }
  }
  
  if(iterations==genLimits[0]){println("START MESSING UP OF MAP");}
  if(iterations==genLimits[1]){println("END MESSING UP OF MAP");}
  
  if(iterations<genLimits[1] && iterations>genLimits[0] && random(1)<0.99){
    _xx=int(random(3,scaledScrWidth-3));
    _yy=int(random(3,scaledScrHeight-3));
    int _xr1=int(random(-8,0));
    int _yr1=int(random(-6,0));
    int _xr=int(random(0,8));
    int _yr=int(random(0,6));
    for(int _y=_yr1;_y<_yr;_y++){
      for(int _x=_yr1;_x<_xr;_x++){
        worldMap.set(_xx+_x,_yy+_y,color(0));
      }
    }
  }
  
  worldMap.set(1+int(mouseX*0.25),1+int(mouseY*0.25),color(0));
  worldMap.set(int(mouseX*0.25),int(mouseY*0.25),color(0));
  worldMap.set(-1+int(mouseX*0.25),-1+int(mouseY*0.25),color(0));
  worldMap.set(1+int(mouseX*0.25),-1+int(mouseY*0.25),color(0));
  
}


void printNeighborlist(String _currentMousePressedArea){
  for(int i=0;i<areas.size();i++){
    Area a = areas.get(i);
    if(a.name==_currentMousePressedArea){
      println(a.name+"'s list of neighbors:");
      for(int _n=0;_n<a.neighbors.size();_n++){
        for(int _b=0;_b<areas.size();_b++){
          Area b = areas.get(_b);
          if(b.id == a.neighbors.get(_n)){
            println(b.name);
          }
        }
      }
    } 
    
  }
}