import com.codedisaster.steamworks.*;



import ddf.minim.spi.*;
import ddf.minim.signals.*;
import ddf.minim.*;
import ddf.minim.analysis.*;
import ddf.minim.ugens.*;
import ddf.minim.effects.*;
  


/*   ---------::::DDD>>>>   Crown & Council
                            by Henrik 'carnalizer' Pettersson, (c)2016 Mojang
*/                  
                            



Minim minim;
AudioPlayer fail1,gold1,gold2,battle1,fort1,castle1,fleet1,trade1,plague1,rebellion1,song,nogo;
//SoundFile fail1,gold1,gold2,battle1,fort1,castle1,fleet1,trade1,plague1,rebellion1;



// GAME STATES *****************
final int STATE_SPLASH= 0;
final int STATE_MENU = 1;
final int STATE_GAME = 2;
final int STATE_GENERATOR = 3;
final int STATE_GAMEOVER = 4;
final int STATE_MAPSTART = 5;
final int STATE_GAMEWON = 6;

int gameState = STATE_SPLASH; 
//int gameState = STATE_GENERATOR;
int gameStateOld = gameState;
final int ACTION_ARMY=0;
final int ACTION_FORT=1;
final int ACTION_CASTLE=2;
final int ACTION_FLEET=3;
final int ACTION_TRADE=4;

Boolean cheat=false;
String cheatCode="";

int level=0;
IntList levelSeeds = new IntList();
float selectableSine=0,pauseTimer,screenShake;

boolean saved=true, playMusic=true;
int musicAt=0;
PImage splash,gui_bg,bg,worldMap,water,miniMap,glow,upgrade_pane,info_pane,player_pane,player_pane_colorplate,player_pane_current,multiSpriteMap,portrait1,portrait2,portrait3,portrait4;

String outMessage="Go!";
String currentMousePressedArea;
boolean noMouseOver = true;
int playerCount=0;
boolean runOnce=true;
boolean runGenerator=true;
boolean autoRun=false;
int iterations =0;
int plugCount=0;
boolean loadMap=true,gameOn=true,waitForClick=true;
int playerTurn,noPlayers,humanPlayers,gameTurn;
ArrayList anims;
ArrayList popMessages;
float aiDelay,aiSpeed;
Button upgradeArmyButton;
Button upgradeFortButton;
Button upgradeTradeButton;
Button upgradeFleetButton;  
TextButton endTurnButton;  

  
  
// GAME WORLD ******************
int[] genLimits = {50,400,550};
PFont font;
int margin=27;
int genAreas;
int gridWidth =9, gridHeight = 9;
int scrWidth = 1024, scrHeight = 768;
int scaledScrWidth = 256, scaledScrHeight = 192;
ArrayList<Area> areas;
ArrayList<Player> players;
int _livingPlayers;
char[][] readmap;
boolean RMB,debug;
float myScale=4;
int baseIncome = 2;
PImage action_army,action_castle,action_fort,action_fleet,action_trade,
       action_army2,action_fort2,action_fleet2,action_trade2,action_uni,
       price_tag,action_selected,warning,
       upgrade_fort,upgrade_castle,upgrade_mine,upgrade_city,upgrade_uni,
       upgrade_fort2,upgrade_city2,
       end_turn,dead,plague,rebellion,ruta1,ruta2,button,blackImg,whiteImg;
float tickerTimer=millis();
float tickerPos=scrWidth*1.35;
String tickerText = "Mojang 2016 all the rights reserved, yo!    ***    Game idea, design, art, code (even the AI!), and sound by HENRIK PETTERSSON, @carnalizer    ***    Made with Processing (processing.org) + Minim library. Music by jukedeck.com. SFX made in SFXR.   ***    Many thanks to Aron, Botteu, Dragonene, Jon, Kappische, Kinten, Notch, Samuel, TheWreck, Tommaso and all of Mojang for being awesome!";
String log="";

int tauntIndex;

String[] taunt = {  "YOU ARE WEAK!",
                    "SURRENDER NOW, AND WE'LL SPARE YOU FAMILY.",
                    "YOUR FACE IS A BATTLEFIELD!",
                    "WAR, WHAT IS IT GOOD FOR? GOLD! SWEET SWEET GOLD!",
                    "DIE DIE DIE DIE DIE",
                    "SHOW ME YOUR ARMY, I'LL SHOW YOU MINE.",
                    "TO SECURE PEACE IS TO PREPARE FOR WAR.",
                    "YO MOMA SO FAT YOU NEED TO EXPAND YOUR EMPIRE.",
                    "YOUR BLOODLINE LOOKS LIKE A CHILD'S DRAWING.",
                    "YOUR FATHER HAS AN AFFINITY FOR FARM ANIMALS.",
                    "YOU THINK THIS IS A GAME?!",
                    "GO BACK TO THE PIGSTY AND TELL MOM I SAID HI.",
                    "IT'S NEVER TO LATE TO GIVE UP.",
                    "YOU'RE PLAYING IN THE BIG LEAGUE NOW.",
                    "LAUGHING OUT LOUD AT THE THOUGHT OF YOUR ARMY.",
                    "GIVE UP. WE ALL KNOW YOU DON'T STAND A CHANCE.",
                    "A KING CAN BE LUNY, BUT THERE ARE LIMITS.",
                  };
String[] tipOfTheDay = {  "AREAS WITH MANY NEIGHBORS\n CAN BE HARDER TO DEFEND.",
                          "TRY TO ISOLATE A FEW AREAS\n AND BLOCK THEM OFF WITH FORTS.",
                          "NEVER USE MORE SHIPS THAN NECESSARY.\n ONCE YOU'RE IN, USE ARMY.",
                          "CHOOSE UPGRADES WITH CARE.",
                          "A NEWLY CONQUERED AREA\n WON'T GIVE YOU INCOME.",
                          "MAYBE YOU CAN USE SHIPS\n TO BYPASS A FORT.",
                          "THE MORE YOU ATTACK AN OPPONENT,\n THE MORE HOSTILE HE'LL BE.",
                          "OPPONENTS WILL GENERALLY ATTACK A\n NEUTRAL AREA BEFORE ONE OF YOURS.",
                          "'M' TOGGLES MUSIC ON/OFF.",
                          "'R' WILL RESTART THE MAP.",
                          "'K' AUTO-PLAYS THE\n REST OF THE MAP.",
                          "'SPACE' ENDS YOUR TURN.",
                          "'G' WILL GENERATE A\n COMPLETELY NEW MAP!",
                          "KEYS 1-4 WILL SET THE NUMBER OF\nHUMAN PLAYERS.",
                          "THERE ARE 75 MAPS, AND YOU CAN\nGENERATE AS MANY AS YOU LIKE!",
                          "RIGHT CLICK WHEN ATTACKING WILL\nATTACK UNTIL YOU WIN OR\nYOU'RE OUT OF FUNDS."
                  };
String currentTip="";

String[] tauntPart1 = { "FACE", "ARMY", "CASTLE", "MOM", "DAD", "FAMILY", "LAND", "KEEP", "BODY", "CROWN", "BRAIN", "RULE", "EMPIRE", "HOME", "BED", "QUEEN", "EFFORT", "WEALTH", "SHIRT"};
String[] tauntPart2 = { "A DWARF", "A WORM", "AN INBRED", "A LUNATIC", "A COW", "A DOG", "A DUNGHEAP", "A DONKEY", "A JESTER", "A DUNCE", "A FARMER", "AN IDIOT", "A LUNATIC", "AN INBRED", "A LIZARD", "A FROG", "A MAGPIE", "A SNAKE", "AN OUTCAST", "A FISH"};
String[] tauntPart3 = { "ASS", "BEHIND", "TURD", "ROTTEN CORPSE", "PISS POT", "BED", "MOM", "OFFSPRING", "JUNK", "OUTHOUSE", "VOMIT", "WART", "PET", "BROTHER", "FOUL ODOR", "FART", "CURSE", "FAILURE", "DISAPPOINTMENT", "ERROR", "BURP", "HORSE", "INSULT"};
String currentTaunt="";

String[] name1 = { "Mar", "Ice", "Wood", "Grey", "Red", "God", "Way", "May", "Hay", "Hy", "In", "Cor", "Slo", "Em", "Man", 
                   "Aber", "Act", "Glan", "Exe", "Usk", "Lund", "Ork", "Bal", "Hol", "Rose", "Blen", "Brad", "Ayle", "Dew",
                   "Grim", "Ten", "Whit", "Cros", "Kirk", "Rug", "Kin", "Caer", "Dal", "Aire", "Croy", "Drum", "Roms", "Horn",
                   "Holm", "Fang", "High", "Low", "Mid", "Gil", "Ruth", "Guth", "Hy", "Wool", "Old", "News", "Hem", "Howe",
                   "King", "Bi", "Bul", "Dark", "Un", "Zu", "Be", "Neu", "Stone", "Bird", "Dog", "Fish", "Nook", "Cart", 
                   "Lar", "Lip", "Hand", "Cat", "Hat", "Gro", "Buck", "Oak", "Carn", "Arn"};
String[] name2 = { "vik", "nom", "mire", "wain", "ick", "ly", "fly", "bir", "bri", "lay", "song", "grass", "stay", "home", 
                   "road", "nock", "bro", "ie", "new", "rock", "path", "moor", "brey", "prey", "hand", "gobb", "vain", "ling",
                   "farm", "hope", "nock", "glen", "ham", "gate", "foss", "ford", "hain", "sop", "ley", "moss", "wall", "wich",
                   "ster", "kirk", "law", "shaw", "pool", "stow", "bury", "ness", "ton", "head", "toft", "va", "ar", "reath", 
                   "say", "key", "ring", "elk", "mund", "vim", "clo", "gut", "har", "weed" };


void setup(){
  
  size(1,1,JAVA2D);
  surface.setResizable(true);
  surface.setSize(scrWidth, scrHeight);
  minim = new Minim(this);
  font = loadFont("BMminiA8-8.vlw");
  textFont(font, 8);
  textAlign(CENTER);
  noSmooth();
  if (!SteamAPI.init("lib\\steamworks4jnatives.jar")) {
      // report error
    println("steamerror!");
    log=System.getProperty("user.dir");
  }
    println("user dir: " + System.getProperty("user.dir"));
  
  loadSound();
  water=createImage(scaledScrWidth,scaledScrHeight,RGB);
  for(int i=0;i<water.pixels.length;i++){
   water.pixels[i] = color(30, 60, 110); 
  } 
  loadImages();

  humanPlayers=1;
  gameSetup();
}

void gameSetup(){
  upgradeArmyButton = new Button(int(scaledScrWidth*0.55),scaledScrHeight-action_army.height,action_army,STATE_GAME);
  upgradeFortButton = new Button(int(scaledScrWidth*0.60),scaledScrHeight-action_fort.height,action_fort,STATE_GAME);
  upgradeTradeButton = new Button(int(scaledScrWidth*0.75),scaledScrHeight-action_trade.height,action_trade,STATE_GAME);
  upgradeFleetButton = new Button(int(scaledScrWidth*0.75),scaledScrHeight-action_fleet.height,action_fleet,STATE_GAME);
  endTurnButton = new TextButton("DONE",int(scaledScrWidth-button.width),scaledScrHeight-button.height,button,0);
  
  //endTurnButton = new TextButton("DONE",0,0,button,0);
  
  screenShake=0;
  water=createImage(scaledScrWidth,scaledScrHeight,RGB);
  for(int i=0;i<water.pixels.length;i++){
   water.pixels[i] = color(30, 60, 110); 
  } 
  loadImages();
  waitForClick=true;
  anims = new ArrayList();
  popMessages = new ArrayList();
  //humanPlayers=1;
  playerTurn=1;
  tauntIndex=int(random(taunt.length *2));
  
  currentTaunt = (tauntIndex < taunt.length) ? taunt[tauntIndex] : getRandomTaunt() ;
  currentTip = tipOfTheDay[int(random(tipOfTheDay.length))];
  //for(int i =0 ; i< 10;i++) println(getRandomTaunt());
  if(gameState!=STATE_SPLASH){gameState=STATE_GENERATOR;}
  genAreas = 10+int(random(gridWidth*gridHeight*0.5+3));
  runOnce=true;
  runGenerator=true;
  plugCount=0;
  iterations=0;
  worldMap=createImage(scaledScrWidth,scaledScrHeight,RGB);
  miniMap=createImage(gridWidth,gridHeight,RGB);
  currentMousePressedArea = "";
  noMouseOver = true;
  areas = new ArrayList<Area>();
  players = new ArrayList<Player>();
  playerCount=0;
  noPlayers=4;
  selectableSine=0;
  aiSpeed=600;
  
  loadLevels();
  if(level>75) level=76;
  randomSeed(levelSeeds.get(level));
  loadMap();
  gameTurn=1;
  gameOn=true;
  checkMusic();
}