class Button {
  PImage pic;
  int inGameState;
  int x1,y1,x2,y2;
  boolean mouseOver,selected;
  String info;
  
  Button(int _x1,int _y1, PImage _pic, int _state){
    pic = _pic;
    x1=_x1;
    y1=_y1;
    x2=pic.width;
    y2=pic.height;
    inGameState=_state;
  }
  
  void update(){
    if(gameState!=inGameState) return;
    
    mouseOver=false;
    
    if(mouseX*0.25 > x1 && mouseX*0.25 < x1+x2 && mouseY*0.25 > y1 && mouseY*0.25 < y1+y2){
      mouseOver=true;
    }
    
    if(mouseOver){
      if(mousePressed){
        tint(120,110,110);
        selected=true;
      }else{
        tint(255,255,255,220);
      }
    }
    image(pic,x1,y1);
      
    noTint();
  }
}

class TextButton {
  int x;
  int y;
  PImage btnImage;
  PImage btnImage_Down;
  int id;
  String caption;
  boolean enabled;
  int margin = 2;
  
  TextButton (String caption, int x, int y, PImage btnImage, int id){
    this.x=x;
    this.y=y;
    this.btnImage=btnImage;
    this.id=id;
    this.caption=caption;
    this.enabled=true;
  }
  
  boolean contains (int xx, int yy){ // i.e. Mouseover
    return (xx > x + margin && xx < x + btnImage.width -margin && yy > y + margin && yy  < y + btnImage.height - margin);
  }
  
  void render(){
    textAlign(CENTER);    
    if (enabled){
      if ( contains( sMouseX(),sMouseY() ) ){
        if (mousePressed == true) {
          renderPressed();
        } else {
          renderUnpressed();
        }
      } else {
        renderNormal();
      }
    } else {
      renderDisabled();
    }
    fill(255,255);
    tint(255,255);

  }
  
  void renderNormal(){
    image(btnImage,x,y);
    fill(20,10,10,200);
    text(caption, x + (btnImage.width*0.5), y + btnImage.height*0.75);
    fill(200,180,160,255);
    text(caption, x + (btnImage.width*0.5), y + btnImage.height*0.70);
  }
  
  void renderDisabled(){
    image(btnImage,x,y);
    fill(255,100);
    text(caption, x + (btnImage.width*0.5), y + btnImage.height*0.70);
    tint(255, 100);
    image(blackImg,x,y,btnImage.width,btnImage.height);    
  }
  
  void renderPressed(){
    image(btnImage,x,y);
    text(caption, x + (btnImage.width*0.5), y + btnImage.height*0.74);
    tint(155, 100);
    image(blackImg,x,y,btnImage.width,btnImage.height);
    text(caption, x + (btnImage.width*0.5), y + btnImage.height*0.74);
  }
  
  void renderUnpressed(){
    image(btnImage,x,y);
    tint(255,255,225, 20);
    image(whiteImg,x,y,btnImage.width,btnImage.height); 
    fill(30,20,20,200);
    text(caption, x + (btnImage.width*0.5), y + btnImage.height*0.75);
    fill(250,230,200,255);
    text(caption, x + (btnImage.width*0.5), y + btnImage.height*0.70);
  }
  
  void update(){
  }
}