
class Area { 
  String name;
  int x1,y1,x2,y2;
  PImage pic;
  PImage mouseOverPic;
  color areaColor;
  boolean mouseOver;
  int namestring;
  int ownedBy;
  int id;
  int income;
  IntList neighbors = new IntList();
  boolean selectable,fort,mine,city,uni;
  int contested,invadedBy;
  boolean chokePoint;
  
  
  Area (int _x1,int _y1,int _x2,int _y2,PImage _im, PImage _moim, color _c, int _id) { 
    // init instance
    id=_id; // place in areas arrayList on creation.
    x1=_x1; // bounds
    y1=_y1;
    x2=_x2;
    y2=_y2;
    
    fort=(random(1)<0.04) ? true : false;
    //castle=false;
    uni= (random(1)<0.05 && fort ==false && level>7) ? true : false;
    mine= (random(1)<0.05 && fort ==false && !uni && level>7) ? true : false;
    city= (random(1)<0.04 && fort ==false && mine ==false && !uni && level>2) ? true : false;
    namestring =int( random(name1.length));
    name=name1[constrain(namestring,0,name1.length-1)];
    namestring =int( random(name2.length) );
    name=name + name2[constrain(namestring,0,name2.length-1)];
    invadedBy=0;
    
    pic=_im;
    pic.mask(_moim);
    mouseOverPic = _moim;
    mouseOverPic.mask(_moim);
    areaColor=_c;
    mouseOver=false;
    selectable = false;    
  } 

  void drawUpgrades() { // castles, forts...
    int _adj=0;
    int _yAdj=-6;
    if(mine){
      _adj = (fort || city || uni) ? 2:-3;
    }
    if(uni){
      _adj = (fort || city || mine) ? 2:-3;
    }
    if(fort){
      Boolean _upg=false;
      if(ownedBy>0){
        if(players.get(ownedBy-1).isActionUpgraded(1)){_upg=true;}
      }
      if(_upg){
        image(upgrade_fort2,x1-_adj-2+(pic.width*0.35),y1+(pic.height*0.35)+_yAdj);
      }else{
        image(upgrade_fort,x1-_adj-2+(pic.width*0.35),y1+(pic.height*0.35)+_yAdj);
      }
    }
    if(city){
      Boolean _upg=false;
      if(ownedBy>0){
        if(players.get(ownedBy-1).isActionUpgraded(3)){_upg=true;}
      }
      if(_upg){
        image(upgrade_city2,x1-_adj-2+(pic.width*0.35),y1+(pic.height*0.35)+_yAdj);
      }else{
        image(upgrade_city,x1-_adj-2+(pic.width*0.35),y1+(pic.height*0.35+_yAdj));
      }
    }
    if(mine){
      image(upgrade_mine,x1+_adj-2+(pic.width*0.35),y1+(pic.height*0.35+_yAdj));
    }
    if(uni){
      image(upgrade_uni,x1+_adj-2+(pic.width*0.35),y1+(pic.height*0.35+_yAdj));
    }
    if (uni && city) println("Error: Has");
  }
  void drawArea(boolean canShowMouseOver) { // game tick update
  calcIncome();
    mouseOver=false;
    if(canShowMouseOver && mouseX*0.25>x1 && mouseX*0.25<x2 && mouseY*0.25 > y1 && mouseY*0.25 < y2){
      if(pic.get(int(mouseX*0.25-x1),int(mouseY*0.25-y1)) != 0){//mouse over!!
        mouseOver=true;
      }
    }
    int _lift = (mouseOver) ? -1 : 0 ;
    if(mouseOver){
      tint(0,150);
      image(pic,x1,y1);
      tint(150,150,150);
      image(pic,x1,y1+_lift);
    }
    
    tint(tintByOwner(ownedBy));
    Player _p = currentPlayer();
    //tintByOwner2( playerTurn, color( int(130)*(1+(sin(selectableSine))*0.2) ) )
    if (selectable && _p.isHuman){
      if(ownedBy>0){
        tint( tintByOwner2( ownedBy, color( int(130)*(1+(sin(selectableSine))*0.4) ) ) );
      }else{
        if (selectable && _p.isHuman){tint(int(150)*(1+(sin(selectableSine))*0.2));}
      }
    }
    
    //
    if(mouseOver){
      if(mousePressed){
        tint(60,120,150);
        currentMousePressedArea = name;
      }else{
        printInfo(name+ ". Income: " + income);
        //tint(tintByOwner(ownedBy));
        //tint(255,255,255,220);
        tint( tintByOwner2( ownedBy, color( 190,210,170 ) ) );
      }
    }
    //if(chokePoint){tint(0,0,0);}
    
    image(pic,x1,y1+_lift);
    noTint();
    
  }
  void drawAreaText(){
    int _inc =income;
    scale(0.5);
    if(ownedBy>0){
      fill(20,20,10,190);
    }else{
      fill(20,20,10,170);
    }
    
    
    text(name,2+(x1+(x2-x1)*0.5)*2,5+(y1+(y2-y1)*0.5)*2);
    text(name,1+(x1+(x2-x1)*0.5)*2,5+(y1+(y2-y1)*0.5)*2);
    if(ownedBy>0){
      fill(80+red(tintByOwner(ownedBy)),80+green(tintByOwner(ownedBy)),70+blue(tintByOwner(ownedBy)),210);
    }else{
      fill(150,140,100,220);
    }
    text(name,1+(x1+(x2-x1)*0.5)*2,4+(y1+(y2-y1)*0.5)*2);
    scale(2);
    
    if(ownedBy>0){
      fill(30,20,10,220);
    }else{
      fill(10,10,10,180);
    }
    
    text( _inc,2+(x1+(x2-x1)*0.5),-1+(y1+(y2-y1)*0.5));
    text( _inc,1+(x1+(x2-x1)*0.5),-1+(y1+(y2-y1)*0.5));
    if(ownedBy>0){
      fill(120+red(tintByOwner(ownedBy)),120+green(tintByOwner(ownedBy)),110+blue(tintByOwner(ownedBy)),230);
    }else{
      fill(150,150,130,220);
    }
    
    text( _inc,1+(x1+(x2-x1)*0.5),-2+(y1+(y2-y1)*0.5));
  }
  
  void findNeighbors(){ // find neighbors and add to neighbor IntList
    for(int _ly=y1;_ly<y2+1;_ly++){
      for(int _lx=x1;_lx<x2+1;_lx++){
        color _checkCol=worldMap.get(_lx,_ly);
        if(_checkCol != areaColor && _checkCol != worldMap.get(0,0) && countSurrounding(worldMap, _lx, _ly, areaColor) >0){ // pixel not like this area and not background and is neighboring to this area//. !!!!
          for(int _i=0;_i<areas.size();_i++){ // search all areas for matching color.
            if(areas.get(_i).areaColor == _checkCol){ // found the area!
              boolean _newNeighbor=true;
              for(int u=neighbors.size()-1;u>=0;u--){ // check all neighbors if already listed
                if(neighbors.get(u) == _i){ // this neighbor is in list
                  _newNeighbor = false;
                }
              }
              if(_newNeighbor){
                neighbors.append(_i);
              }
            }
          }
        }
      }
    }
    neighbors.sort();
    for(int u=neighbors.size()-1;u>0;u--){
      //println(name,id, "---------------------------",neighbors.size());
      if(neighbors.get(u) == id){
        //println("---------------------------",neighbors.get(u));
        neighbors.remove(u);
      }
    }
    //println("---------------------------------------",id);
    for(int u=neighbors.size()-1;u>0;u--){
      //println("---------------------------",neighbors.get(u));
      if(u>=1){
        if(neighbors.get(u) == neighbors.get(u-1)){
          neighbors.remove(u);
        }
      }
    }
    calcIncome();
   
  }
  void calcIncome(){
   income= 1;
   income = (income<0) ? 0 : income;
   if(city){
     income++;
      if(ownedBy>0 && players.get(ownedBy-1).isActionUpgraded(3)){
        income++;
      }
    }
  }
  void findChokePoints(){
    chokePoint = false;
    //println(name,"-",id);
    //println(name + "'s (" + id +") neighbors ("+neighbors.size()+") are: ");
    if(neighbors.size()>1){
      chokePoint = true;
      int chokepointDisprovalPoints = 0;
      for(int _n1=0;_n1<neighbors.size();_n1++){ //Go through all neighbors.
        Area _neighbor1 = areas.get(neighbors.get(_n1));
        //println("    " +_neighbor1.name,"("+_neighbor1.id+"), ");
        for(int _n2=0;_n2<neighbors.size();_n2++){ //Go through all neighbors.
          Area _neighbor2 = areas.get(neighbors.get(_n2));
          //println("compare ",_neighbor1.name+"'s neighbors with:");
          if(_neighbor1.id != _neighbor2.id ){
            //println("listing",_neighbor2.name+"'s neighbor id's");
            for(int _n2list=0;_n2list<_neighbor2.neighbors.size();_n2list++){
              //println("          "+ _neighbor2.neighbors.get(_n2list));
              if(_neighbor2.neighbors.get(_n2list) == _neighbor1.id ) {
                chokepointDisprovalPoints++;
              }
            }
          }
        }
        if(chokepointDisprovalPoints == neighbors.size()) {
          chokePoint = false; 
        }
      }
    }
  }
} 

class Bounds {
  int x1,y1,x2,y2;
  Bounds (int _x1,int _y1,int _x2,int _y2){
    x1=_x1;
    y1=_y1;
    x2=_x2;
    y2=_y2;
    
  }
}