void AI_turn(){
  
  Player _AI = currentPlayer();
  while(_AI.hasUpgrade()){
    int _try = constrain(int(random(level)),0,4);
    if(!_AI.actions.get(_try).upgraded){
      _AI.actions.get(_try).upgraded=true;
      _AI.research=0;
    }
  }
  
   for(int i=0;i<_AI.aiDiplomacy.length;i++){
     if(_AI.aiDiplomacy[i] > 0.9){_AI.aiDiplomacy[i] -= _AI.aiDiplomacy[i]*0.05;}
   }
  
  if (_AI.gold<1 || _AI.isAlive==false){return;}
  float[] _evals = new float[5*areas.size()];
  for(int _action=0;_action<constrain(level,1,5);_action++){
    Action _a = _AI.actions.get(_action);
    for(int _testArea=0;_testArea<areas.size();_testArea++){
      //println("TEsting action",_action,"on area",_testArea);
      int _index =_action*areas.size() + _testArea;
      _evals[_index]=0;
      if (_AI.gold<_a.cost){
         // cannot afford action.
        continue;
      }
      switch(_action){
        case 0:
            selectableAreas(_action);
            //println("  ------------------",evalAttack(_testArea));
            _evals[_index]=evalAttack(_testArea);
        break;
        case 1:
            selectableAreas(_action);
            _evals[_index]=evalFort(_testArea);
        break;
        case 2:
            selectableAreas(_action);
            _evals[_index]=evalArmada(_testArea);
        break;
        case 3:
          selectableAreas(_action);
          _evals[_index]=evalVillage(_testArea);
        break;
        case 4:
          selectableAreas(_action);
          _evals[_index]=evalUni(_testArea);
        break;
        default:
        break;
      }
    }
  }
  int _bestEval=0;
  for(int _i=0;_i<_evals.length;_i++){
    if( _evals[_i] > _evals[_bestEval]){
      _bestEval=_i;
      //print("^--");
    }
      //println(_i, _i % areas.size(), _evals[_i]);
  }
  if (_evals[_bestEval]==0){
    iterations=0;
    endTurn();
  }
  //println("best:",_bestEval);
  int _tryAction = int(_bestEval/areas.size());
  int _tryArea = _bestEval % areas.size();
  Area _area = areas.get(_tryArea);
  
  //println("FIND ACTION:",_tryAction, "and APPLY ON", _tryArea,"with name",_area.name);

  unselectActions();
  selectableAreas(_tryAction); 
  Action _a= _AI.actions.get(_tryAction);
  _a.selected=true;

  areaClicked(_area.name);
}

float evalAttack(int _testArea){
  Area _area = areas.get(_testArea);
  Player _AI = currentPlayer();
  float _score=0;
  if( _area.selectable ){_score=1 + random(0.1);}
  _score *= (1 + (_area.income*0.09));
  if(_AI.dominance > 0.53){_score *= 1.8;}
  if(_area.fort){_score *= 0.6;}
  //if(_area.castle){_score *= 0.35;}
  if(_area.city){_score *= 1.3;}
  if(_area.mine){_score *= 1.3;}
  if(_area.ownedBy==0){
    _score *= 1.2;
  }else{
    _score *= _AI.aiDiplomacy[_area.ownedBy-1];
  } 
  if(_area.ownedBy>0){
    Player _owner = players.get(_area.ownedBy-1);
    _score *= (0.5 + (level * 0.01) + _owner.dominance);
  }
  _score *= (1-(_area.neighbors.size()*0.05));
  
  _score *= _AI.aiPreference[0];
  return _score;
}

float evalFort(int _testArea){
  Area _area = areas.get(_testArea);
  Player _AI = currentPlayer();
  float _score=0;
  if( _area.selectable ){_score=0.9 + random(0.18);}
  if(_area.chokePoint){_score *= 1.9;}
  _score *= (1 + (_area.income*0.3));
  _score *= (_area.mine) ? 1.3 : 1 ;
  //_score *= ((_area.neighbors.size()*0.1));
  _score *= (_area.city) ? 0.2 : 1 ;
  _score *= (0.6 + _area.contested * 0.10);
  if(_AI.dominance > 0.6){_score *= 0.6;}
  if(_area.uni){_score=0;}
  _score *= _AI.aiPreference[1];
  return _score;
}

float evalArmada(int _testArea){
  Area _area = areas.get(_testArea);
  Player _AI = currentPlayer();
  float _score=0;
  if( _area.selectable ){_score=0.5 + random(0.1);}
  _score *= (1 + (_area.income*0.1));
  if(_area.fort){_score *= 0.6;}
  //if(_area.castle){_score *= 0.3;}
  if(_area.ownedBy==0){_score *= (1.25 + (level * 0.01));} // this should be depending on diplomacy factors not yet implemented.
  _score *= (1-(_area.neighbors.size()*0.1));
  if(_area.mine){_score *= 1.1;}
  if(_AI.dominance > 0.6){_score *= 1.2;}
  
  _score *= _AI.aiPreference[3];
  return _score;
}

float evalVillage(int _testArea){
  Area _area = areas.get(_testArea);
  Player _AI = currentPlayer();
  float _score=0;
  if( _area.selectable ){_score=1 + random(-0.4,0.3);}
  float _ns = 1;
  for(int i=0;i<_area.neighbors.size();i++){
    Area _a = areas.get(_area.neighbors.get(i));
    if(_a.ownedBy != playerTurn){_ns -= 0.35;}
  }
  _score *= _ns;
  if (_area.fort){_score *= 0.7;}
  _score *= (1.2-(_area.neighbors.size()*0.1));
  if(_area.mine){_score *= 0.4;}
  float _c = _area.contested * -0.1;
  
  _score *= 1 + constrain(_c,-100,0.2);
  _score *= _AI.aiPreference[4];
  
  if(_area.uni){_score=0;}
  
  return _score;
}

float evalUni(int _testArea){
  Area _area = areas.get(_testArea);
  Player _AI = currentPlayer();
  float _score=0;
  if( _area.selectable && countUnis(_AI) <= _AI.maxUni){_score=1 + random(-0.4,0.3);}
  _score*=_AI.uniFondness;
  
  return _score;
}

void adjustDiplomacy(int _defender){
  if(_defender>0){
    Player _p = players.get(_defender-1);
    _p.aiDiplomacy[playerTurn-1] += 0.08;
  }
}