/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.AudioOutput;
import ddf.minim.effects.LowPassSP;
import ddf.minim.ugens.Damp;
import ddf.minim.ugens.Instrument;
import ddf.minim.ugens.Noise;
import ddf.minim.ugens.Oscil;
import ddf.minim.ugens.Summer;
import ddf.minim.ugens.Waveform;
import ddf.minim.ugens.Waves;

public class DefaultInstrument
implements Instrument {
    private Oscil toneOsc;
    private Noise noiseGen;
    private Damp noiseEnv;
    private Damp toneEnv;
    private AudioOutput output;
    private Summer summer;
    private LowPassSP lpFilter;

    public DefaultInstrument(float frequency, AudioOutput output) {
        this.output = output;
        float amplitude = 0.3f;
        this.noiseGen = new Noise(0.4f * amplitude, Noise.Tint.WHITE);
        this.noiseEnv = new Damp(0.05f);
        this.lpFilter = new LowPassSP(2.0f * frequency, output.sampleRate());
        this.toneOsc = new Oscil(frequency, 0.9f * amplitude, (Waveform)Waves.TRIANGLE);
        this.toneEnv = new Damp(2.0f / frequency, 1.0f);
        this.summer = new Summer();
        this.toneOsc.patch(this.toneEnv).patch(this.summer);
        this.noiseGen.patch(this.noiseEnv).patch(this.lpFilter).patch(this.summer);
    }

    @Override
    public void noteOn(float dur) {
        this.summer.patch(this.output);
        this.toneEnv.setDampTimeFromDuration(dur);
        this.toneEnv.activate();
        this.noiseEnv.activate();
    }

    @Override
    public void noteOff() {
        this.summer.unpatch(this.output);
    }
}

