/*
 * Decompiled with CFR 0.152.
 */
package com.codedisaster.steamworks;

import com.codedisaster.steamworks.SteamAPI;
import com.codedisaster.steamworks.SteamAuth;
import com.codedisaster.steamworks.SteamID;
import com.codedisaster.steamworks.SteamInterface;
import com.codedisaster.steamworks.SteamUserCallback;
import com.codedisaster.steamworks.SteamUserCallbackAdapter;
import java.nio.Buffer;

public class SteamUser
extends SteamInterface {
    public SteamUser(SteamUserCallback callback) {
        super(SteamAPI.getSteamUserPointer(), SteamUser.createCallback(new SteamUserCallbackAdapter(callback)));
    }

    public SteamID getSteamID() {
        return new SteamID(SteamUser.getSteamID(this.pointer));
    }

    public int getAuthSessionTicket(Buffer authTicket) {
        int[] sizeInBytes = new int[1];
        int ticket = SteamUser.getAuthSessionTicket(this.pointer, authTicket, authTicket.capacity(), sizeInBytes);
        authTicket.limit(sizeInBytes[0]);
        return ticket;
    }

    public SteamAuth.BeginAuthSessionResult beginAuthSession(Buffer authTicket, SteamID steamID) {
        int result = SteamUser.beginAuthSession(this.pointer, authTicket, authTicket.limit(), steamID.handle);
        return SteamAuth.BeginAuthSessionResult.byOrdinal(result);
    }

    public void endAuthSession(SteamID steamID) {
        SteamUser.endAuthSession(this.pointer, steamID.handle);
    }

    public void cancelAuthTicket(int authTicket) {
        SteamUser.cancelAuthTicket(this.pointer, authTicket);
    }

    public SteamAuth.UserHasLicenseForAppResult userHasLicenseForApp(SteamID steamID, long appID) {
        return SteamAuth.UserHasLicenseForAppResult.byOrdinal(SteamUser.userHasLicenseForApp(this.pointer, steamID.handle, appID));
    }

    private static native long createCallback(SteamUserCallbackAdapter var0);

    private static native long getSteamID(long var0);

    private static native int getAuthSessionTicket(long var0, Buffer var2, int var3, int[] var4);

    private static native int beginAuthSession(long var0, Buffer var2, int var3, long var4);

    private static native void endAuthSession(long var0, long var2);

    private static native void cancelAuthTicket(long var0, int var2);

    private static native int userHasLicenseForApp(long var0, long var2, long var4);
}

