/*
 * Decompiled with CFR 0.152.
 */
package com.codedisaster.steamworks;

import com.codedisaster.steamworks.SteamAPI;
import com.codedisaster.steamworks.SteamAPICall;
import com.codedisaster.steamworks.SteamInterface;
import com.codedisaster.steamworks.SteamPublishedFileID;
import com.codedisaster.steamworks.SteamUGCCallback;
import com.codedisaster.steamworks.SteamUGCCallbackAdapter;
import com.codedisaster.steamworks.SteamUGCDetails;
import com.codedisaster.steamworks.SteamUGCQuery;
import java.util.Collection;
import java.util.EnumSet;

public class SteamUGC
extends SteamInterface {
    public SteamUGC(SteamUGCCallback callback) {
        super(SteamAPI.getSteamUGCPointer(), SteamUGC.createCallback(new SteamUGCCallbackAdapter(callback)));
    }

    public SteamUGCQuery createQueryUserUGCRequest(long accountID, UserUGCList listType, MatchingUGCType matchingType, UserUGCListSortOrder sortOrder, long creatorAppID, long consumerAppID, int page) {
        return new SteamUGCQuery(SteamUGC.createQueryUserUGCRequest(this.pointer, accountID, listType.ordinal(), matchingType.ordinal(), sortOrder.ordinal(), creatorAppID, consumerAppID, page));
    }

    public SteamUGCQuery createQueryAllUGCRequest(UGCQueryType queryType, MatchingUGCType matchingType, long creatorAppID, long consumerAppID, int page) {
        return new SteamUGCQuery(SteamUGC.createQueryAllUGCRequest(this.pointer, queryType.ordinal(), matchingType.ordinal(), creatorAppID, consumerAppID, page));
    }

    public SteamUGCQuery createQueryUGCDetailsRequest(SteamPublishedFileID publishedFileID) {
        long[] fileIDs = new long[]{publishedFileID.handle};
        return new SteamUGCQuery(SteamUGC.createQueryUGCDetailsRequest(this.pointer, fileIDs, 1));
    }

    public SteamUGCQuery createQueryUGCDetailsRequest(Collection<SteamPublishedFileID> publishedFileIDs) {
        int size = publishedFileIDs.size();
        long[] fileIDs = new long[size];
        int index = 0;
        for (SteamPublishedFileID fileID : publishedFileIDs) {
            fileIDs[index++] = fileID.handle;
        }
        return new SteamUGCQuery(SteamUGC.createQueryUGCDetailsRequest(this.pointer, fileIDs, size));
    }

    public boolean setReturnTotalOnly(SteamUGCQuery query, boolean returnTotalOnly) {
        return SteamUGC.setReturnTotalOnly(this.pointer, query.handle, returnTotalOnly);
    }

    public SteamAPICall sendQueryUGCRequest(SteamUGCQuery query) {
        return new SteamAPICall(SteamUGC.sendQueryUGCRequest(this.pointer, this.callback, query.handle));
    }

    public boolean getQueryUGCResult(SteamUGCQuery query, int index, SteamUGCDetails details) {
        return SteamUGC.getQueryUGCResult(this.pointer, query.handle, index, details);
    }

    public boolean releaseQueryUserUGCRequest(SteamUGCQuery query) {
        return SteamUGC.releaseQueryUserUGCRequest(this.pointer, query.handle);
    }

    public SteamAPICall subscribeItem(SteamPublishedFileID publishedFileID) {
        return new SteamAPICall(SteamUGC.subscribeItem(this.pointer, this.callback, publishedFileID.handle));
    }

    public SteamAPICall unsubscribeItem(SteamPublishedFileID publishedFileID) {
        return new SteamAPICall(SteamUGC.unsubscribeItem(this.pointer, this.callback, publishedFileID.handle));
    }

    public int getNumSubscribedItems() {
        return SteamUGC.getNumSubscribedItems(this.pointer);
    }

    public int getSubscribedItems(SteamPublishedFileID[] publishedFileIds) {
        long[] ids = new long[publishedFileIds.length];
        int nb = SteamUGC.getSubscribedItems(this.pointer, ids, publishedFileIds.length);
        for (int i = 0; i < nb; ++i) {
            publishedFileIds[i] = new SteamPublishedFileID(ids[i]);
        }
        return nb;
    }

    public Collection<ItemState> getItemState(SteamPublishedFileID publishedFileID) {
        return ItemState.fromBits(SteamUGC.getItemState(this.pointer, publishedFileID.handle));
    }

    public boolean getItemInstallInfo(SteamPublishedFileID publishedFileID, ItemInstallInfo installInfo) {
        return SteamUGC.getItemInstallInfo(this.pointer, publishedFileID.handle, installInfo);
    }

    public boolean getItemDownloadInfo(SteamPublishedFileID publishedFileID, ItemDownloadInfo downloadInfo) {
        long[] values = new long[2];
        if (SteamUGC.getItemDownloadInfo(this.pointer, publishedFileID.handle, values)) {
            downloadInfo.bytesDownloaded = values[0];
            downloadInfo.bytesTotal = values[1];
            return true;
        }
        return false;
    }

    @Deprecated
    public SteamAPICall requestUGCDetails(SteamPublishedFileID publishedFileID, int maxAgeSeconds) {
        return new SteamAPICall(SteamUGC.requestUGCDetails(this.pointer, this.callback, publishedFileID.handle, maxAgeSeconds));
    }

    private static native long createCallback(SteamUGCCallbackAdapter var0);

    private static native long createQueryUserUGCRequest(long var0, long var2, int var4, int var5, int var6, long var7, long var9, int var11);

    private static native long createQueryAllUGCRequest(long var0, int var2, int var3, long var4, long var6, int var8);

    private static native long createQueryUGCDetailsRequest(long var0, long[] var2, int var3);

    private static native boolean setReturnTotalOnly(long var0, long var2, boolean var4);

    private static native long sendQueryUGCRequest(long var0, long var2, long var4);

    private static native boolean getQueryUGCResult(long var0, long var2, int var4, SteamUGCDetails var5);

    private static native boolean releaseQueryUserUGCRequest(long var0, long var2);

    private static native long subscribeItem(long var0, long var2, long var4);

    private static native long unsubscribeItem(long var0, long var2, long var4);

    private static native int getNumSubscribedItems(long var0);

    private static native int getSubscribedItems(long var0, long[] var2, int var3);

    private static native int getItemState(long var0, long var2);

    private static native boolean getItemInstallInfo(long var0, long var2, ItemInstallInfo var4);

    private static native boolean getItemDownloadInfo(long var0, long var2, long[] var4);

    private static native long requestUGCDetails(long var0, long var2, long var4, int var6);

    public static class ItemDownloadInfo {
        long bytesDownloaded;
        long bytesTotal;

        public long getBytesDownloaded() {
            return this.bytesDownloaded;
        }

        public long getBytesTotal() {
            return this.bytesTotal;
        }
    }

    public static class ItemInstallInfo {
        private String folder;
        private int sizeOnDisk;

        public String getFolder() {
            return this.folder;
        }

        public int getSizeOnDisk() {
            return this.sizeOnDisk;
        }
    }

    public static enum ItemState {
        None(0),
        Subscribed(1),
        LegacyItem(2),
        Installed(4),
        NeedsUpdate(8),
        Downloading(16),
        DownloadPending(32);

        private final int bits;
        private static final ItemState[] values;

        private ItemState(int bits) {
            this.bits = bits;
        }

        static Collection<ItemState> fromBits(int bits) {
            EnumSet<ItemState> itemStates = EnumSet.noneOf(ItemState.class);
            for (ItemState itemState : values) {
                if ((bits & itemState.bits) != itemState.bits) continue;
                itemStates.add(itemState);
            }
            return itemStates;
        }

        static {
            values = ItemState.values();
        }
    }

    public static enum UGCQueryType {
        RankedByVote,
        RankedByPublicationDate,
        AcceptedForGameRankedByAcceptanceDate,
        RankedByTrend,
        FavoritedByFriendsRankedByPublicationDate,
        CreatedByFriendsRankedByPublicationDate,
        RankedByNumTimesReported,
        CreatedByFollowedUsersRankedByPublicationDate,
        NotYetRated,
        RankedByTotalVotesAsc,
        RankedByVotesUp,
        RankedByTextSearch,
        RankedByTotalUniqueSubscriptions;

    }

    public static enum UserUGCListSortOrder {
        CreationOrderDesc,
        CreationOrderAsc,
        TitleAsc,
        LastUpdatedDesc,
        SubscriptionDateDesc,
        VoteScoreDesc,
        ForModeration;

    }

    public static enum MatchingUGCType {
        Items,
        ItemsMtx,
        ItemsReadyToUse,
        Collections,
        Artwork,
        Videos,
        Screenshots,
        AllGuides,
        WebGuides,
        IntegratedGuides,
        UsableInGame,
        ControllerBindings,
        GameManagedItems;

    }

    public static enum UserUGCList {
        Published,
        VotedOn,
        VotedUp,
        VotedDown,
        WillVoteLater,
        Favorited,
        Subscribed,
        UsedOrPlayed,
        Followed;

    }
}

