/*
 * Decompiled with CFR 0.152.
 */
package com.codedisaster.steamworks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class SteamSharedLibraryLoader {
    private final String libraryPath;
    private final boolean fromJar;
    private String libraryCrc;
    private static boolean alreadyLoaded = false;

    private SteamSharedLibraryLoader(String libraryPath, boolean fromJar) {
        this.libraryPath = libraryPath;
        this.fromJar = fromJar;
        if (libraryPath != null && fromJar) {
            try {
                this.libraryCrc = this.crc(new FileInputStream(new File(libraryPath)));
            }
            catch (FileNotFoundException e) {
                this.libraryCrc = Integer.toHexString(libraryPath.hashCode());
            }
        }
    }

    private String getLibNameWindows(String sharedLibName, boolean is64Bit) {
        return sharedLibName + (is64Bit ? "64" : "") + ".dll";
    }

    private String getLibNameLinux(String sharedLibName, boolean is64Bit) {
        return "lib" + sharedLibName + (is64Bit ? "64" : "") + ".so";
    }

    private String getLibNameMac(String sharedLibName) {
        return "lib" + sharedLibName + ".dylib";
    }

    private void loadLibraries(String ... libraryNames) throws IOException {
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        boolean isWindows = osName.contains("Windows");
        boolean isLinux = osName.contains("Linux");
        boolean isMac = osName.contains("Mac");
        boolean is64Bit = osArch.equals("amd64") || osArch.equals("x86_64");
        for (String libraryName : libraryNames) {
            String librarySystemName = "";
            if (isWindows) {
                librarySystemName = this.getLibNameWindows(libraryName, is64Bit);
            }
            if (isLinux) {
                librarySystemName = this.getLibNameLinux(libraryName, is64Bit);
            }
            if (isMac) {
                librarySystemName = this.getLibNameMac(libraryName);
            }
            String fullPath = this.fromJar ? this.extractLibrary(librarySystemName) : this.libraryPath + "/" + librarySystemName;
            String absolutePath = new File(fullPath).getCanonicalPath();
            System.load(absolutePath);
        }
    }

    private String extractLibrary(String sharedLibName) throws IOException {
        int length;
        File nativesPath = new File(System.getProperty("java.io.tmpdir") + "/steamworks4j/" + this.libraryCrc);
        File nativeFile = new File(nativesPath, sharedLibName);
        if (!nativesPath.exists() && !nativesPath.mkdirs()) {
            throw new IOException("Error creating temp folder: " + nativesPath.getCanonicalPath());
        }
        ZipFile zip = new ZipFile(this.libraryPath);
        ZipEntry entry = zip.getEntry(sharedLibName);
        InputStream input = zip.getInputStream(entry);
        if (input == null) {
            throw new IOException("Error extracting " + sharedLibName + " from " + this.libraryPath);
        }
        FileOutputStream output = new FileOutputStream(nativeFile);
        byte[] buffer = new byte[4096];
        while ((length = input.read(buffer)) != -1) {
            output.write(buffer, 0, length);
        }
        input.close();
        output.close();
        return nativeFile.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String crc(InputStream input) {
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[4096];
        try {
            int length;
            while ((length = input.read(buffer)) != -1) {
                crc.update(buffer, 0, length);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                input.close();
            }
            catch (IOException ignored) {}
        }
        return Long.toHexString(crc.getValue());
    }

    static boolean extractAndLoadLibraries(boolean fromJar, String libraryPath) {
        if (alreadyLoaded) {
            return true;
        }
        if (fromJar && libraryPath == null) {
            libraryPath = System.getProperty("java.io.tmpdir") + "/steamworks4j/steamworks4j-natives.jar";
            File libraryDirectory = new File(libraryPath).getParentFile();
            if (!libraryDirectory.exists() && !libraryDirectory.mkdirs()) {
                return false;
            }
            try {
                int length;
                InputStream input = SteamSharedLibraryLoader.class.getResourceAsStream("/steamworks4j-natives.jar");
                FileOutputStream output = new FileOutputStream(new File(libraryPath));
                byte[] cache = new byte[4096];
                do {
                    if ((length = input.read(cache)) <= 0) continue;
                    output.write(cache, 0, length);
                } while (length > 0);
                input.close();
                output.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        SteamSharedLibraryLoader loader = new SteamSharedLibraryLoader(libraryPath, fromJar);
        try {
            loader.loadLibraries("steam_api", "steamworks4j");
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        alreadyLoaded = true;
        return true;
    }
}

