/*
 * Decompiled with CFR 0.152.
 */
package com.codedisaster.steamworks;

import com.codedisaster.steamworks.SteamAPI;
import com.codedisaster.steamworks.SteamAPICall;
import com.codedisaster.steamworks.SteamException;
import com.codedisaster.steamworks.SteamInterface;
import com.codedisaster.steamworks.SteamPublishedFileID;
import com.codedisaster.steamworks.SteamPublishedFileUpdateHandle;
import com.codedisaster.steamworks.SteamRemoteStorageCallback;
import com.codedisaster.steamworks.SteamRemoteStorageCallbackAdapter;
import com.codedisaster.steamworks.SteamUGCFileWriteStreamHandle;
import com.codedisaster.steamworks.SteamUGCHandle;
import java.nio.ByteBuffer;

public class SteamRemoteStorage
extends SteamInterface {
    public SteamRemoteStorage(SteamRemoteStorageCallback callback) {
        super(SteamAPI.getSteamRemoteStoragePointer(), SteamRemoteStorage.createCallback(new SteamRemoteStorageCallbackAdapter(callback)));
    }

    public boolean fileWrite(String name, ByteBuffer data, int length) throws SteamException {
        if (!data.isDirect()) {
            throw new SteamException("Buffer must be direct!");
        }
        return SteamRemoteStorage.fileWrite(this.pointer, name, data, length);
    }

    public boolean fileRead(String name, ByteBuffer buffer, int capacity) throws SteamException {
        if (!buffer.isDirect()) {
            throw new SteamException("Buffer must be direct!");
        }
        return SteamRemoteStorage.fileRead(this.pointer, name, buffer, capacity);
    }

    public boolean fileDelete(String name) {
        return SteamRemoteStorage.fileDelete(this.pointer, name);
    }

    public SteamAPICall fileShare(String name) {
        return new SteamAPICall(SteamRemoteStorage.fileShare(this.pointer, this.callback, name));
    }

    public SteamUGCFileWriteStreamHandle fileWriteStreamOpen(String name) {
        return new SteamUGCFileWriteStreamHandle(SteamRemoteStorage.fileWriteStreamOpen(this.pointer, name));
    }

    public boolean fileWriteStreamWriteChunk(SteamUGCFileWriteStreamHandle stream, ByteBuffer data, int length) {
        return SteamRemoteStorage.fileWriteStreamWriteChunk(this.pointer, stream.handle, data, length);
    }

    public boolean fileWriteStreamClose(SteamUGCFileWriteStreamHandle stream) {
        return SteamRemoteStorage.fileWriteStreamClose(this.pointer, stream.handle);
    }

    public boolean fileWriteStreamCancel(SteamUGCFileWriteStreamHandle stream) {
        return SteamRemoteStorage.fileWriteStreamCancel(this.pointer, stream.handle);
    }

    public boolean fileExists(String name) {
        return SteamRemoteStorage.fileExists(this.pointer, name);
    }

    public int getFileSize(String name) {
        return SteamRemoteStorage.getFileSize(this.pointer, name);
    }

    public int getFileCount() {
        return SteamRemoteStorage.getFileCount(this.pointer);
    }

    public String getFileNameAndSize(int index, int[] sizes) {
        return SteamRemoteStorage.getFileNameAndSize(this.pointer, index, sizes);
    }

    public SteamAPICall ugcDownload(SteamUGCHandle fileHandle, int priority) {
        return new SteamAPICall(SteamRemoteStorage.ugcDownload(this.pointer, this.callback, fileHandle.handle, priority));
    }

    public int ugcRead(SteamUGCHandle fileHandle, ByteBuffer buffer, int capacity, int offset, UGCReadAction action) {
        return SteamRemoteStorage.ugcRead(this.pointer, fileHandle.handle, buffer, capacity, offset, action.ordinal());
    }

    public SteamAPICall publishWorkshopFile(String file, String previewFile, long consumerAppID, String title, String description, PublishedFileVisibility visibility, String[] tags, WorkshopFileType workshopFileType) {
        return new SteamAPICall(SteamRemoteStorage.publishWorkshopFile(this.pointer, this.callback, file, previewFile, consumerAppID, title, description, visibility.ordinal(), tags, tags != null ? tags.length : 0, workshopFileType.ordinal()));
    }

    public SteamPublishedFileUpdateHandle createPublishedFileUpdateRequest(SteamPublishedFileID publishedFileID) {
        return new SteamPublishedFileUpdateHandle(SteamRemoteStorage.createPublishedFileUpdateRequest(this.pointer, publishedFileID.handle));
    }

    public boolean updatePublishedFileFile(SteamPublishedFileUpdateHandle updateHandle, String file) {
        return SteamRemoteStorage.updatePublishedFileFile(this.pointer, updateHandle.handle, file);
    }

    public boolean updatePublishedFilePreviewFile(SteamPublishedFileUpdateHandle updateHandle, String previewFile) {
        return SteamRemoteStorage.updatePublishedFilePreviewFile(this.pointer, updateHandle.handle, previewFile);
    }

    public boolean updatePublishedFileTitle(SteamPublishedFileUpdateHandle updateHandle, String title) {
        return SteamRemoteStorage.updatePublishedFileTitle(this.pointer, updateHandle.handle, title);
    }

    public boolean updatePublishedFileDescription(SteamPublishedFileUpdateHandle updateHandle, String description) {
        return SteamRemoteStorage.updatePublishedFileDescription(this.pointer, updateHandle.handle, description);
    }

    public SteamAPICall commitPublishedFileUpdate(SteamPublishedFileUpdateHandle updateHandle) {
        return new SteamAPICall(SteamRemoteStorage.commitPublishedFileUpdate(this.pointer, this.callback, updateHandle.handle));
    }

    private static native long createCallback(SteamRemoteStorageCallbackAdapter var0);

    private static native boolean fileWrite(long var0, String var2, ByteBuffer var3, int var4);

    private static native boolean fileRead(long var0, String var2, ByteBuffer var3, int var4);

    private static native boolean fileDelete(long var0, String var2);

    private static native long fileShare(long var0, long var2, String var4);

    private static native long fileWriteStreamOpen(long var0, String var2);

    private static native boolean fileWriteStreamWriteChunk(long var0, long var2, ByteBuffer var4, int var5);

    private static native boolean fileWriteStreamClose(long var0, long var2);

    private static native boolean fileWriteStreamCancel(long var0, long var2);

    private static native boolean fileExists(long var0, String var2);

    private static native int getFileSize(long var0, String var2);

    private static native int getFileCount(long var0);

    private static native String getFileNameAndSize(long var0, int var2, int[] var3);

    private static native long ugcDownload(long var0, long var2, long var4, int var6);

    private static native int ugcRead(long var0, long var2, ByteBuffer var4, int var5, int var6, int var7);

    private static native long publishWorkshopFile(long var0, long var2, String var4, String var5, long var6, String var8, String var9, int var10, String[] var11, int var12, int var13);

    private static native long createPublishedFileUpdateRequest(long var0, long var2);

    private static native boolean updatePublishedFileFile(long var0, long var2, String var4);

    private static native boolean updatePublishedFilePreviewFile(long var0, long var2, String var4);

    private static native boolean updatePublishedFileTitle(long var0, long var2, String var4);

    private static native boolean updatePublishedFileDescription(long var0, long var2, String var4);

    private static native long commitPublishedFileUpdate(long var0, long var2, long var4);

    public static enum WorkshopFileType {
        Community;

    }

    public static enum PublishedFileVisibility {
        Public,
        FriendsOnly,
        Private;

    }

    public static enum UGCReadAction {
        ContinueReadingUntilFinished,
        ContinueReading,
        Close;

    }
}

