/*
 * Decompiled with CFR 0.152.
 */
package com.crack.me.active.ui.replace;

import com.crack.me.active.ui.Loggable;
import com.crack.me.active.ui.replace.JarReplacer;
import com.crack.me.active.ui.replace.stream.ReplaceStreamType;
import com.crack.me.active.ui.replace.stream.SystemResourceReplaceStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class SpecialSignatureVerifierReplacer
extends JarReplacer {
    private static final String[] FOR_INDEXS = new String[]{"com.genuitec.eclipse.ui", "com.genuitec.eclipse.core", "com.genuitec.eclipse.easie.core", "com.genuitec.eclipse.j2eedt", "com.genuitec.myeclipse.product"};
    private ClassLoader classLoader = null;
    private static final String METHOD_NAME = "verifyJarSignatures";
    private static final String SERVER_VALIDATE_ACTION_CLASS = "com/genuitec/eclipse/easie/core/ui/action/ServerValidateAction.class";
    private static final String MECP_LIST_CONTENT_PROVIDER_CLASS = "com/genuitec/eclipse/core/ui/preference/MECPListContentProvider.class";
    private static final String TAGLIB_READER_CLASS = "com/genuitec/eclipse/j2eedt/taglib/TagLibReader.class";
    private static final String TLD_EXT_INFO_CLASS = "com/genuitec/eclipse/j2eedt/ui/taglib/TLDExtInfo.class";
    private static final String PRODUCT_VIEWER_CLASS = "com/genuitec/myeclipse/product/ProductViewer.class";

    public SpecialSignatureVerifierReplacer(Loggable loggable) {
        super(loggable);
        this.addReplaceStream(SERVER_VALIDATE_ACTION_CLASS, new SystemResourceReplaceStream(SERVER_VALIDATE_ACTION_CLASS, ReplaceStreamType.UPDATE));
        this.addReplaceStream(MECP_LIST_CONTENT_PROVIDER_CLASS, new SystemResourceReplaceStream(MECP_LIST_CONTENT_PROVIDER_CLASS, ReplaceStreamType.UPDATE));
        this.addReplaceStream(TAGLIB_READER_CLASS, new SystemResourceReplaceStream(TAGLIB_READER_CLASS, ReplaceStreamType.UPDATE));
        this.addReplaceStream(TLD_EXT_INFO_CLASS, new SystemResourceReplaceStream(TLD_EXT_INFO_CLASS, ReplaceStreamType.UPDATE));
        this.addReplaceStream(PRODUCT_VIEWER_CLASS, new SystemResourceReplaceStream(PRODUCT_VIEWER_CLASS, ReplaceStreamType.UPDATE));
    }

    @Override
    public boolean isFileLegal(File file) {
        return this.isAllowedCheckedFile(file) ? this.isSignatureVerifierFile(this.classLoader, file) : false;
    }

    @Override
    public boolean checkReplaceCondition() {
        if (this.classLoader == null) {
            this.logger.log("classloader was not load");
            return false;
        }
        return super.checkReplaceCondition();
    }

    @Override
    public void setJarFileList(List<File> list) {
        super.setJarFileList(list);
        this.classLoader = this.getClassLoader(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSignatureVerifierFile(ClassLoader classLoader, File file) {
        boolean bl2 = false;
        if (file != null && classLoader != null) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(file);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    if (!this.isClassFile(jarEntry)) continue;
                    String string = jarEntry.getName();
                    String string2 = this.getClassName(jarEntry);
                    if (!this.isAllowedCheckedClass(string2) || !this.isSignatureVerifierClass(classLoader, string2)) continue;
                    bl2 = true;
                    if (this.isInReplaceFileStreams(string)) continue;
                    this.logger.log("found SignatureVerifier.File [" + string + "],but was not in list.can't replace it.");
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        return bl2;
    }

    private boolean isAllowedChecked(String string) {
        for (String string2 : FOR_INDEXS) {
            if (string.indexOf(string2) == -1) continue;
            return true;
        }
        return false;
    }

    private boolean isAllowedCheckedClass(String string) {
        return this.isAllowedChecked(string);
    }

    private boolean isAllowedCheckedFile(File file) {
        if (file != null) {
            return this.isAllowedChecked(file.getAbsolutePath());
        }
        return false;
    }

    private boolean isSignatureVerifierClass(ClassLoader classLoader, String string) {
        try {
            Class<?> clazz = classLoader.loadClass(string);
            return this.isSignatureVerifierMethods(clazz);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private boolean isClassFile(JarEntry jarEntry) {
        return jarEntry != null ? jarEntry.getName().endsWith(".class") : false;
    }

    private String getClassName(JarEntry jarEntry) {
        if (jarEntry != null) {
            String string = jarEntry.getName();
            string = string.substring(0, string.indexOf(".class"));
            string = string.replaceAll("/", ".");
            return string;
        }
        return null;
    }

    private boolean isSignatureVerifierMethods(Class<?> clazz) {
        try {
            clazz.getDeclaredMethod(METHOD_NAME, String.class, String.class);
            clazz.getDeclaredMethod(METHOD_NAME, String[].class);
            clazz.getDeclaredMethod(METHOD_NAME, new Class[0]);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private ClassLoader getClassLoader(List<File> list) {
        if (list != null && list.size() != 0) {
            URL[] uRLArray = new URL[list.size()];
            for (int i2 = 0; i2 < uRLArray.length; ++i2) {
                try {
                    uRLArray[i2] = list.get(i2).toURI().toURL();
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
            return new URLClassLoader(uRLArray, this.getClass().getClassLoader());
        }
        return null;
    }

    @Override
    public String getProcessInfo() {
        return "Replacing [SpecialSignatureVerifier].";
    }
}

