/*
 * Decompiled with CFR 0.152.
 */
package com.crack.me.active;

import java.io.IOException;

public final class Hex {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Hex() {
    }

    public static Appendable append(Appendable a2, short in) {
        return Hex.append(a2, (long)in, 4);
    }

    public static Appendable append(Appendable a2, short in, int length) {
        return Hex.append(a2, (long)in, length);
    }

    public static Appendable append(Appendable a2, int in) {
        return Hex.append(a2, (long)in, 8);
    }

    public static Appendable append(Appendable a2, int in, int length) {
        return Hex.append(a2, (long)in, length);
    }

    public static Appendable append(Appendable a2, long in) {
        return Hex.append(a2, in, 16);
    }

    public static Appendable append(Appendable a2, long in, int length) {
        try {
            int lim = (length << 2) - 4;
            while (lim >= 0) {
                a2.append(DIGITS[(byte)(in >> lim) & 0xF]);
                lim -= 4;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return a2;
    }

    public static Appendable append(Appendable a2, byte[] bytes) {
        try {
            byte[] byArray = bytes;
            int n2 = bytes.length;
            int n3 = 0;
            while (n3 < n2) {
                byte b2 = byArray[n3];
                a2.append(DIGITS[(byte)((b2 & 0xF0) >> 4)]);
                a2.append(DIGITS[(byte)(b2 & 0xF)]);
                ++n3;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return a2;
    }

    public static long parseLong(CharSequence s2) {
        long out = 0L;
        int shifts = 0;
        int i2 = 0;
        while (i2 < s2.length() && shifts < 16) {
            char c2 = s2.charAt(i2);
            if (c2 > '/' && c2 < ':') {
                shifts = (byte)(shifts + 1);
                out <<= 4;
                out |= (long)(c2 - 48);
            } else if (c2 > '@' && c2 < 'G') {
                shifts = (byte)(shifts + 1);
                out <<= 4;
                out |= (long)(c2 - 55);
            } else if (c2 > '`' && c2 < 'g') {
                shifts = (byte)(shifts + 1);
                out <<= 4;
                out |= (long)(c2 - 87);
            }
            ++i2;
        }
        return out;
    }

    public static short parseShort(String s2) {
        short out = 0;
        int shifts = 0;
        int i2 = 0;
        while (i2 < s2.length() && shifts < 4) {
            char c2 = s2.charAt(i2);
            if (c2 > '/' && c2 < ':') {
                shifts = (byte)(shifts + 1);
                out = (short)(out << 4);
                out = (short)(out | c2 - 48);
            } else if (c2 > '@' && c2 < 'G') {
                shifts = (byte)(shifts + 1);
                out = (short)(out << 4);
                out = (short)(out | c2 - 55);
            } else if (c2 > '`' && c2 < 'g') {
                shifts = (byte)(shifts + 1);
                out = (short)(out << 4);
                out = (short)(out | c2 - 87);
            }
            ++i2;
        }
        return out;
    }

    public static byte[] decodeHex(char[] data) throws Exception {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new Exception("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i2 = 0;
        int j2 = 0;
        while (j2 < len) {
            int f2 = Hex.toDigit(data[j2], j2) << 4;
            f2 |= Hex.toDigit(data[++j2], j2);
            ++j2;
            out[i2] = (byte)(f2 & 0xFF);
            ++i2;
        }
        return out;
    }

    protected static int toDigit(char ch, int index) throws Exception {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new Exception("Illegal hexadecimal charcter " + ch + " at index " + index);
        }
        return digit;
    }

    public static char[] encodeHex(byte[] data) {
        int l2 = data.length;
        char[] out = new char[l2 << 1];
        int i2 = 0;
        int j2 = 0;
        while (i2 < l2) {
            out[j2++] = DIGITS[(0xF0 & data[i2]) >>> 4];
            out[j2++] = DIGITS[0xF & data[i2]];
            ++i2;
        }
        return out;
    }

    public byte[] decode(byte[] array) throws Exception {
        return Hex.decodeHex(new String(array).toCharArray());
    }

    public Object decode(Object object) throws Exception {
        try {
            char[] charArray = object instanceof String ? ((String)object).toCharArray() : (char[])object;
            return Hex.decodeHex(charArray);
        }
        catch (ClassCastException e2) {
            throw new Exception(e2.getMessage());
        }
    }

    public byte[] encode(byte[] array) {
        return new String(Hex.encodeHex(array)).getBytes();
    }

    public Object encode(Object object) throws Exception {
        try {
            byte[] byteArray = object instanceof String ? ((String)object).getBytes() : (byte[])object;
            return Hex.encodeHex(byteArray);
        }
        catch (ClassCastException e2) {
            throw new Exception(e2.getMessage());
        }
    }
}

