/**
 * [OElove] (C)2010-2099 oelove.com Inc.biz
 * Email: service@phpcoo.com，phpcoo@qq.com
 * This is not a freeware, use is subject to license terms
 * $ LastTime 2020.04.08 Update by OE/CL $ 滚动类
*/
class OEMarquee {
    constructor({el}) {
        this.el = el;
        this.i = 1;
        this.length = 0;
        this.wrapper = this.el.firstElementChild;
        this.itemH = this.el.clientHeight;
        this.getNodeLength();
        if (this.isInit) {
            this.cloneNode();
            this.scroll();
        }
    }
    getNodeLength() {
        this.isInit = this.el.clientHeight < this.wrapper.clientHeight;
        this.length = this.wrapper.children.length;
    }
    cloneNode() {
        let first = this.wrapper.firstElementChild.cloneNode(true);
        let last = this.wrapper.lastElementChild.cloneNode(true);
        this.wrapper.appendChild(first);
        this.wrapper.insertBefore(last, this.wrapper.firstElementChild);
        this.wrapper.style.transform = `translate3d(0, -${this.itemH}px, 0)`;
        this.el.style.height = this.itemH + 'px';
        var nodeArr = Array.prototype.slice.call(this.wrapper.children);
        nodeArr.forEach((v) => {
            v.style.height = this.itemH + 'px';
        });
    }
    scroll() {
        setInterval(() => {
            this.i++;
            let scrollY = -this.itemH * this.i;
            this.wrapper.style.transition = `transform ease .4s`;
            this.wrapper.style.transform = `translate3d(0, ${scrollY}px, 0)`;
            if (Math.abs(scrollY) == this.itemH * (this.length + 1)) {
                setTimeout(() => {
                    this.i = 1;
                    this.wrapper.style.transition = `transform ease 0s`;
                    this.wrapper.style.transform = `translate3d(0, -${this.itemH}px, 0)`;
                }, 400);
            }
        }, 3000);
    }
}