/**
 * [OElove Webapp] (C)2010-2099 oelove.com Inc.
 * Email: service@phpcoo.com，phpcoo@qq.com
 * This is not a freeware, use is subject to license terms
 * $ LastTime 2020.03.02 Update by CL $
*/
$(function(){
    function OEJubao() {
        this.api_url = WAP_APPFILE+"&c=jubao";
        this.wake();
    }
    OEJubao.prototype = {
        
        wake:function() {
            var _this = this;
            
            //选择分类
            $(document).on("click", "[f='but_sel_jubaocat']", function(){
                var $val = $(this).attr("data-val");
                $("[f='but_sel_jubaocat']").removeClass("current");
                $(this).addClass("current");
                $("#jubao_blacktype").val($val);
                
            });
            //提交举报
            $(document).on("click", "[f='but_submit_jubao']", function(){
                _this.obj_id = $(this).attr("id");
                
                var $homeuid = $("#jubao_homeuid").val();
                if ($homeuid == '' || $homeuid == '0') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '举报对象不能为空'
                    });
                    return;
                }
                
                var $jubao_catid = $("#jubao_blacktype").val();
                if ($jubao_catid == '' || $jubao_catid == '0') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请选择分类'
                    });
                    return;
                }
                var $jubao_mobile = $("#jubao_mobile").val();
                if ($jubao_mobile == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请填写手机号'
                    });
                    return;
                }
                var $jubao_email = $("#jubao_email").val();
                
                var $jubao_content = $("#jubao_content").val();
                if ($jubao_content == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请填写举报描述'
                    });
                    return;
                }
                
                
                var $img1 = $("#img1_url").val();
                if (typeof($img1) == 'undefined') {
                    $img1 = '';
                }
                
                
                var $send_data = {
                    'a':'savejubao', 'homeuid':$homeuid, 
                    'blacktype':$jubao_catid, 'judes':$jubao_content, 
                    'jumobile':$jubao_mobile, 'juemail':$jubao_email, 'juimg':$img1
                }
                _this.sendJubao($send_data);
                
            });
        },
        
        //提交举报
        sendJubao:function($send_data) {
            var _this = this;
            if (!$("#"+_this.obj_id).hasClass("forbid_submit")) {
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);
                $("#"+_this.obj_id).addClass("forbid_submit");
                
                $.ajax({
                    type: "POST",
                    url: _this.api_url,
                    cache: false,
                    data:$send_data, 
                    dataType: "json",
                    success: function($data) {
                        var $json = eval($data);
                        var $response = $json.response;
                        var $result = $json.result;
                        
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        
                        if ($response == "1") { 
                            OEUI.toast({
                                type: 'bottom',
                                text: '提交成功，请等待客服处理'
                            });
                            setTimeout(function(){
                                window.location.reload();
                            }, 1000);
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '提交失败，请检查';
                            }
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            }); 
                        }
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                    },
                    error: function() {
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        OEUI.toast({
                            type: 'bottom',
                            text: '网络繁忙，请稍后再试！'
                        });
                    }
                });
                
            } 
        }
        
    }
    new OEJubao();
});

