/**
 * [OElove] (C)2010-2099 oelove.com Inc.biz
 * Email: service@phpcoo.com，phpcoo@qq.com
 * This is not a freeware, use is subject to license terms
 * $ LastTime 2020.04.24 Update by OE/CL $
*/
$(function(){
    
    //实名认证
    function OEYunrz() {
        this.api_url = WAP_APPFILE+'&c=yunrz';
        this._this_dialog = null;
        this.slide_time = 200;
        this.obj_id = null;
        
        this.agree = ''; //是否同意协议
        this.truename = ''; //姓名
        this.idnumber = ''; //身份证号
        this.mobile = ''; //手机号
        this.mobilecode = ''; //验证码
        
        this.clickRz();
    }
    
    OEYunrz.prototype = {
        
        clickRz:function() {
            var _this = this;
            
            //默认显示温馨提示
            setTimeout(function() {
                _this._this_dialog = OEUI.Dialog({
                    el: '#tips_box',
                    animated: 'zoomIn',
                    time:_this.slide_time,
                    type: '2'
                }); 
            }, 100);
            //关闭提示
            $(document).on("click", "[f='but_close_tips']", function(){
                //$("#tips_box").hide();
                if (_this._this_dialog) {
                    _this._this_dialog.hide();
                }
            });
            
            //查看协议
            $(document).on("click", "[f='but_open_xieyi']", function(){
                _this._this_dialog = OEUI.Dialog({
                    el: '#xieyi_box',
                    animated: 'slideRightIn',
                    time:_this.slide_time
                }); 
            });
            //关闭协议
            $(document).on("click", "[f='but_close_xieyi']", function(){
                if (_this._this_dialog) {
                    _this._this_dialog.hide();
                }
            });
            
            //同意协议
            $(document).on("click", "[f='but_agree']", function(){
                if ($(this).find("i").hasClass('color_9')) {
                    $(this).find('i').removeClass('color_9').addClass('color_main');
                    $("#agree").val('1');
                    _this.agree = 1;
                }
                else {
                    $(this).find('i').removeClass('color_main').addClass('color_9');
                    $("#agree").val('0');
                    _this.agree = 0;
                }
            });
            
            //提交
            $(document).on("click", "[f='but_submit_rz']", function(){
                _this.obj_id = $(this).attr("id");
                if (_this.agree != '1') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '你还没同意认证服务协议'
                    });
                    return;
                }
                _this.truename = $("#truename").val();
                _this.idnumber = $("#idnumber").val();
                _this.mobile = $("#mobile").val();
                _this.mobilecode = $("#mobilecode").val();
                
                if (_this.truename == '' || _this.truename == null) {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请填写真实姓名'
                    });
                    return;
                }
                if (_this.idnumber == '' || _this.idnumber == null) {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请填写身份证号'
                    });
                    return;
                }
                if (_this.mobile == '' || _this.mobile == null) {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请填写手机号'
                    });
                    return;
                }
                if (_this.mobilecode == '' || _this.mobilecode == null) {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请填写手机验证码'
                    });
                    return;
                }
                _this.submitRz();
            });
            
        },
        
        //执行认证
        submitRz:function() {
            var _this = this;
            
            if (!$("#"+_this.obj_id).hasClass("forbid_submit")) {
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);
                $("#"+_this.obj_id).addClass("forbid_submit");
                
                $.ajax({
                    type: "POST",
                    url: _this.api_url,
                    cache: false,
                    data: {
                        a:'submit',
                        truename:_this.truename, idnumber:_this.idnumber,
                        mobile:_this.mobile, mobilecode:_this.mobilecode
                    },
                    dataType: "json",
                    success: function($data) {
                        var $json = eval($data);
                        var $response = $json.response;
                        var $result = $json.result;
                        
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        
                        if ($response == '1') { 
                            //免费认证
                            window.location.href = WAP_APPFILE+"&c=yunresult&nofollow=1&rzno="+$result;
                        }
                        else if ($response == '2') {
                            //付费认证 (收银台)
                            window.location.href = _ROOT_PATH+"index.php?m=wap&c=pay&paynum="+$result;
                        }
                        else if ($response == '22') {
                            //付费认证 (唤醒微信)
                            var $pay_data = {
                                'paynum': $result,
                                'forward':''
                            };
                            _inst_oewx_pay.initPay($pay_data);
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '提交失败，请检查';
                            }
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            }); 
                        }
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                    },
                    
                    error: function() {
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        OEUI.toast({
                            type: 'bottom',
                            text: '网络繁忙，请稍后再试！'
                        });
                    }
                });
                
            }
        }
    }
    
    new OEYunrz();

});