/**
 * [OElove] (C)2010-2099 oelove.com Webapp
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/03/12 by bo $
*/
$(function () {
    function OERz() {
        this.api_url = WAP_APPFILE+"&c=rz";
        this._this_dialog = ''; //弹窗对象
        this.slide_time = 200; //速度
        this.obj_id = '';
        this.type = ''; //认证类型 
        
        this.wake();
        this.wakeSubmit();
        this.clickStateMent(); // 21.4.16
    }
    
    
    OERz.prototype = {
        
        wake:function() {
            var _this = this;
            
            //弹出认证框
            $(document).on("click", "[f='open_rz_dialog']", function(){
                _this.type = $(this).attr("data-type");
                _this.getRzDialog();
            });
            
            //关闭认证框
            $(document).on("click", "[f='close_rz_dialog']", function(){
                if (_this._this_dialog) {
                    _this._this_dialog.hide();
                }
            });
            
            //检测数据是否可用
            $(document).on("blur", "[f='check_data']", function(){
                var $type = $(this).attr("data-type");
                var $val = $(this).val();
                _this.checkData($type, $val);
            });
            
            //修改微信
            $(document).on("click", "[f='open_weixin_input']", function(){
                _this._this_dialog = OEUI.Dialog({
                    el: '#weixin_dialog',
                    animated: 'slideBottomIn',
                    time:_this.slide_time
                });
            });
            //关闭微信
            $(document).on("click", "[f='close_weixin_input']", function(){
                if (_this._this_dialog) {
                    _this._this_dialog.hide();
                }
            });
            //提交微信
            $(document).on("click", "[f='confirm_weixin_input']", function(){
                _this.obj_id = $(this).attr("id");
                var $weixin = $("#weixin").val();
                if ($weixin == '') {
                    OEUI.toast({
                        text: '请填写微信号'
                    });
                    return;
                }
                var $send_data = {
                    'a':'editweixin', 'weixin':$weixin 
                }
                _this.postRz($send_data, 'weixin');
            });
            
        },
        //载入认证内容
        getRzDialog:function() {
            var _this = this;
            var loading = null;
            var timer = setTimeout(function () {
                loading = OEUI.showLoading({
                    type:2
                });
            }, 200);
            
            $.ajax({
                type: "POST",
                url: _this.api_url,
                cache: false,
                data:{
                    a:'rz', type:_this.type
                },
                dataType: "json",
                success: function($data) {
                    var $json = eval($data);
                    var $response = $json.response;
                    var $result = $json.result;
                    
                    clearTimeout(timer);
                    loading && loading.hideLoading();
                    timer = null;
                    
                    if ($response == "1") {
                        $("#rz_dialog_data").html($result);
                        _this._this_dialog = OEUI.Dialog({
                            el: '#rz_dialog',
                            animated: 'slideRightIn',
                            time:_this.slide_time
                        });
                    }
                    else if ($response == '2') {
                        //跳到自助实名认证页
                        window.location.href = WAP_APPFILE+"&c=yunrz&from=rz";
                    }
                    else {
                        if ($result.length == 0 || $result == '') {
                            $result = '获取认证项失败，请检查！';
                        }
                        OEUI.toast({
                            type: 'bottom',
                            text: $result
                        }); 
                    }
                },
                error: function() {
                    clearTimeout(timer);
                    loading && loading.hideLoading();
                    timer = null;
                    OEUI.toast({
                        type: 'bottom',
                        text: '网络繁忙，请稍后再试！'
                    });
                }
            });  
        },
        
        //检测数据
        checkData:function($type, $val){
            var _this = this;
            var $name = $val;
            var $userid = $("#userid").val();
            if (typeof($userid) == 'undefined') {
                $userid = 0;
            }
            $.ajax({
                type: "POST",
                url: _this.api_url,
                cache: false,
                data:{
                    a:'check', check_type:$type, name:$val, userid:$userid
                },
                dataType: "json",
                success: function($data) {
                    var $json = eval($data);
                    var $response = $json.response;
                    var $result = $json.result;
                    
                    if ($response == "1") {
                        
                    }
                    else {
                        if ($result != '') {
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            }); 
                        }
                        else {
                            $result = '';
                            if ($type == 'mobile') {
                                $result = '该手机号已存在，请使用另外一个';
                            }
                            else if ($type == 'email') {
                                $result = '该邮箱已存在，请使用另外一个';
                            }
                            else if ($type == 'qq') {
                                $result = '该QQ已存在，请使用另外一个';
                            }
                            else if ($type == 'idnumber') {
                                $result = '该身份证号已存在，请使用另外一个';
                            }
                            if ($result != '') {
                                OEUI.toast({
                                    type: 'bottom',
                                    text: $result
                                }); 
                            }
                        }
                    }
                },
                error: function() {
                    OEUI.toast({
                        type: 'bottom',
                        text: '网络繁忙，请稍后再试！'
                    });
                }
            });  
        },
        
        //触发提交
        wakeSubmit:function() {
            var _this = this;
            
            //认证手机
            $(document).on("click", "[f='but_submit_mobile']", function(){
                _this.obj_id = $(this).attr("id");
                
                var $mobile = $("#mobile").val();
                if ($mobile == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请填写手机号'
                    });
                    return;
                }
                var $mobilecode = $("#mobilecode").val();
                if ($mobilecode == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请填写手机验证码'
                    });
                    return;
                }
                var $send_data = {
                    'a':'mobilerz', 'mobile':$mobile, 'mobilecode':$mobilecode
                };
                _this.postRz($send_data, 'mobile');
            });
            
            //认证邮箱
            $(document).on("click", "[f='but_submit_email']", function(){
                _this.obj_id = $(this).attr("id");
                
                var $email = $("#email").val();
                if ($email == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请填写邮箱'
                    });
                    return;
                }
                var $emailcode = $("#emailcode").val();
                if ($emailcode == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请填写邮箱验证码'
                    });
                    return;
                }
                var $send_data = {
                    'a':'emailrz', 'email':$email, 'emailcode':$emailcode
                };
                _this.postRz($send_data, 'email');
            });
            
            //认证QQ
            $(document).on("click", "[f='but_submit_qq']", function(){
                _this.obj_id = $(this).attr("id");
                
                var $qq = $("#qq").val();
                if ($qq == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请填写QQ号'
                    });
                    return;
                }
                var $qqcode = $("#qqcode").val();
                if ($qqcode == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请填写QQ邮箱验证码'
                    });
                    return;
                }
                var $send_data = {
                    'a':'qqrz', 'qq':$qq, 'qqcode':$qqcode
                };
                _this.postRz($send_data, 'qq');
            });
            
            //实名认证
            $(document).on("click", "[f='but_submit_idcard']", function(){
                _this.obj_id = $(this).attr("id");
                
                var $truename = $("#truename").val();
                if ($truename == '') {
                    OEUI.toast({
                        text: '请填写姓名'
                    });
                    return;
                }
                var $idnumber = $("#idnumber").val();
                if ($idnumber == '') {
                    OEUI.toast({
                        text: '请填写身份证号'
                    });
                    return;
                }
                var $paper1 = $("#paper1_url").val();
                if ($paper1 == '') {
                    OEUI.toast({
                        text: '请上传身份证正面'
                    });
                    return;
                }
                var $paper2 = $("#paper2_url").val();
                if ($paper2 == '') {
                    OEUI.toast({
                        text: '请上传身份证反面'
                    });
                    return;
                }
                var $paper3 = $("#paper3_url").val();
                if (typeof($paper3) == 'undefined') {
                    $paper3 = '';
                }
                else {
                    if ($paper3 == '') {
                        OEUI.toast({
                            text: '请上传手持身份证照'
                        });
                        return;
                    }
                }
                
                
                var $send_data = {
                    'a':'idrz', 'truename':$truename, 'idnumber':$idnumber, 
                    'paper1':$paper1, 'paper2':$paper2, 'paper3':$paper3
                };
                _this.postRz($send_data, 'idnumber');
            });
            
            //学历认证
            $(document).on("click", "[f='but_submit_edu']", function(){
                _this.obj_id = $(this).attr("id");
                
                var $eduimg = $("#eduimg_url").val();
                if ($eduimg == '') {
                    OEUI.toast({
                        text: '请上传学历证书'
                    });
                    return;
                }
                
                var $send_data = {
                    'a':'edurz', 'eduimg':$eduimg
                };
                _this.postRz($send_data, 'edu');
            });
            
            //婚况认证
            $(document).on("click", "[f='but_submit_marry']", function(){
                _this.obj_id = $(this).attr("id");
                
                var $marryimg = $("#marryimg_url").val();
                if ($marryimg == '') {
                    OEUI.toast({
                        text: '请上传婚况证件'
                    });
                    return;
                }
                
                var $send_data = {
                    'a':'marryrz', 'marryimg':$marryimg
                };
                _this.postRz($send_data, 'marry');
            });
            
            //房子认证
            $(document).on("click", "[f='but_submit_house']", function(){
                _this.obj_id = $(this).attr("id");
                
                var $houseimg = $("#houseimg_url").val();
                if ($houseimg == '') {
                    OEUI.toast({
                        text: '请上传房产证/不动产证'
                    });
                    return;
                }
                
                var $send_data = {
                    'a':'houserz', 'houseimg':$houseimg
                };
                _this.postRz($send_data, 'house');
            });
            
            //车子认证
            $(document).on("click", "[f='but_submit_car']", function(){
                _this.obj_id = $(this).attr("id");
                
                var $carimg = $("#carimg_url").val();
                if ($carimg == '') {
                    OEUI.toast({
                        text: '请上传汽车行驶证'
                    });
                    return;
                }
                
                var $send_data = {
                    'a':'carrz', 'carimg':$carimg
                };
                _this.postRz($send_data, 'car');
            });
        },
        
        
        //保存认证
        postRz:function($send_data, $type) {
            var _this = this;
            
            if (!$("#"+_this.obj_id).hasClass("forbid_submit")) {
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);
                $("#"+_this.obj_id).addClass("forbid_submit");
                
                $.ajax({
                    type: "POST",
                    url: _this.api_url,
                    cache: false,
                    data: $send_data,
                    dataType: "json",
                    success: function($data) {
                        var $json = eval($data);
                        var $response = $json.response;
                        var $result = $json.result;
                        
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        
                        if ($response == "1") {
                            $result = '提交成功，请等待网站审核';
                            if ($type == 'mobile' || $type == 'email' || $type == 'qq') {
                                $result = '认证成功';
                            }
                            else if ($type == 'weixin') {
                                $result = '修改成功';
                            }
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            });
                            setTimeout(function(){
                                if (_this._this_dialog) {
                                    _this._this_dialog.hide(function(){
                                        window.location.reload();
                                    });
                                }
                            }, 800);
                            
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '提交失败，请检查';
                            }
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            }); 
                        }
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                    },
                    error: function() {
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        OEUI.toast({
                            type: 'bottom',
                            text: '网络繁忙，请稍后再试！'
                        });
                    }
                });
                
            }
        },
        //婚况声明 21.4.16
        clickStateMent:function() {
            var _this = this;
            $(document).on("click", "[f='but_statement']", function(){
                var elm = $(this);
                if (!$(elm).hasClass("forbid_submit")) {
                    var loading = null;
                    var timer = setTimeout(function () {
                        loading = OEUI.showLoading({
                            type:2
                        });
                    }, 200);
                    $(elm).addClass("forbid_submit");
                    
                    $.ajax({
                        type: "POST",
                        url: WAP_APPFILE,
                        cache: false,
                        data: {
                            c:'statement', a:'geturl'
                        },
                        dataType: "json",
                        success: function(data) {
                            var response = data.response;
                            var result = data.result;
                            
                            clearTimeout(timer);
                            loading && loading.hideLoading();
                            timer = null;
                            
                            if (response == '1') {
                                window.location.href = result;
                            }
                            else if (response == '2') {
                                OEUI.toast({
                                    type: 'bottom',
                                    text: '你的婚况声明已提交，请等待客服审核'
                                }); 
                            }
                            
                            //未完成实名认证 21.01.28
                            else if (response == '10') {
                                OEUI.alert({
                                    title: '温馨提示',
                                    text: '请先完成实名认证',
                                    confirm: function () {
                                        
                                    }
                                });
                            }
                            else {
                                if (result == '' || result == '') {
                                    result = '提交失败，请检查';
                                }
                                OEUI.toast({
                                    type: 'bottom',
                                    text: result
                                }); 
                            }
                            $(elm).removeClass("forbid_submit");
                        },
                        error: function() {
                            $(elm).removeClass("forbid_submit");
                            clearTimeout(timer);
                            loading && loading.hideLoading();
                            timer = null;
                            OEUI.toast({
                                type: 'bottom',
                                text: '网络繁忙，请稍后再试！'
                            });
                        }
                    });
                }
            });
        }
        
    }
    new OERz();
});