/**
 * [OElove] (C)2010-2099 oelove.com Webapp
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/03/26 by CL $
*/
$(function () {
    
    function OEPaycard () {
        this.api_url = WAP_APPFILE;
        this.type = '1'; //类型

        this.wake();
    }
    
    
    OEPaycard.prototype = {
        
        //触发
        wake:function() {
            var _this = this;
            
            //选择类型
            $(document).on("click", "[f='but_sel_type']", function(e){
                _this.type = e.currentTarget.dataset.type;
                $(this).removeClass('bo_eb color_9').addClass('bo_main color_main').siblings().removeClass('bo_main color_main').addClass('bo_eb color_9');
                if (_this.type == '1') {
                    $('#userid_box').css('display', 'none');
                } 
                else {
                    $('#userid_box').css('display', 'block');
                }
            });
            
            //提交充值
            $(document).on("click", "[f='but_submit_recharge']", function(){
                _this.obj_id = $(this).attr("id");
                
                var $cardnum = $('#cardnum').val();
                if ($cardnum == '') {
                    OEUI.toast({
                        type: 'bottom',  
                        text: '请填写充值卡号'
                    });
                    return;
                }
                var $cardpwd = $('#cardpwd').val();
                if ($cardpwd == '') {
                    OEUI.toast({
                        type: 'bottom',  
                        text: '请填写充值卡密码'
                    });
                    return;
                }
                var $useuid = $("#useuid").val();
                
                if (_this.type == '2') {
                    if ($useuid == '') {
                        OEUI.toast({
                            type: 'bottom',  
                            text: '请填写他人UID'
                        });
                        return;
                    }
                }
                else {
                    $useuid = '';
                }
                
                var $send_data = {
                    'cardnum':$cardnum, 'cardpwd':$cardpwd, 'useuid':$useuid
                };
                
                _this.submitRecharge($send_data);
            });
            
        },
        
        //提交充值
        submitRecharge:function($send_data) {
            var _this = this;
            if (!$("#"+_this.obj_id).hasClass("forbid_submit")) {
                
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);

                $.ajax({
                    type: 'POST',
                    url: _this.api_url+'&c=paycard&a=saverech',
                    data: $send_data,
                    dataType: "json",
                    success: function($data) {
                        var $json = eval($data);
                        var $response = $json.response;
                        var $result = $json.result;
                        
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        
                        if ($response == '1') {
                            OEUI.toast({
                                type: 'bottom', 
                                text: '充值成功'
                            });
                            setTimeout(function(){
                                window.location.reload();
                            }, 600);
                        }
                        else {
                            /*
                            if ($result.length == 0 || $result == '') {
                                $result = '充值失败，请检查';
                            }
                            */
                            if ($result == "1") {
                                $result = "该卡号已过期";
                            }
                            else if ($result == "2") {
                                //已使用
                                $result = "该卡已使用";
                            }
                            else if ($result == "3") {
                                //已冻结
                                $result = "该卡已冻结";
                            }
                            else {
                                $result = '充值失败，请检查卡号和密码';
                            }
                            
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            }); 
                        }
                    },
                    error: function () {
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        OEUI.toast({
                            type: 'bottom',
                            text: '网络繁忙，请稍后再试！'
                        });
                    }
                });
                
            }
        }
    }
    new OEPaycard();
});