/**
 * [OElove] (C)2010-2099 oelove.com Webapp
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/03/26 by CL $
*/
$(function () {
    function OEDiary () {
        this.api_url = WAP_APPFILE+"&c=mydiary";
        this.id = ''; //日记id
        this.obj_id = '';
        
        this.wake();
    }
    
    OEDiary.prototype = {
        
        
        wake: function () {
            var _this = this;
            
            //发布提交
            $(document).on("click", "[f='but_submit_add']", function(){
                _this.obj_id = $(this).attr("id");
                var $title = $("#title").val();
                var $content = myeditor.html();
                var $thumbimg = $("#img_thumb").val();
                if (typeof($thumbimg) == 'undefined') {
                    $thumbimg = '';
                }
                var $drawimg = $("#img_url").val();
                if (typeof($drawimg) == 'undefined') {
                    $drawimg = '';
                }
                
                if ($title == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请填写日记标题'
                    });
                    return;
                }
                if ($content == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请填写日记内容'
                    });
                    return;
                }
                
                var $send_data = {
                    'a':'saveadd', 'title':$title, 'content':$content, 
                    'thumbimg':$thumbimg, 'drawimg':$drawimg
                };
                _this.sendData($send_data, "add");
            });
            
            //提交编辑
            $(document).on("click", "[f='but_submit_edit']", function(){
                _this.obj_id = $(this).attr("id");
                _this.id = $(this).attr("data-id");
                
                var $title = $("#title").val();
                var $content = myeditor.html();
                var $thumbimg = $("#img_thumb").val();
                if (typeof($thumbimg) == 'undefined') {
                    $thumbimg = '';
                }
                var $drawimg = $("#img_url").val();
                if (typeof($drawimg) == 'undefined') {
                    $drawimg = '';
                }
                
                if ($title == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请填写日记标题'
                    });
                    return;
                }
                if ($content == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请填写日记内容'
                    });
                    return;
                }
                
                var $send_data = {
                    'a':'saveedit', 'id':_this.id, 'title':$title, 'content':$content, 
                    'thumbimg':$thumbimg, 'drawimg':$drawimg
                };
                _this.sendData($send_data, "edit");
            });
            
            //删除
            $(document).on("click", "[f='but_del_diary']", function(){
                _this.obj_id = $(this).attr("id");
                _this.id = $(this).attr("data-id");
                var $send_data = {
                    'a':'del', 'id':_this.id
                };
                OEUI.confirm({
                    title: '温馨提示',
                    text: '确定要删除吗？',
                    confirm: function () {
                        _this.sendData($send_data, "del");
                    }
                });                
            });
            
        },
        
        //sendData
        sendData:function($send_data, $type) {
            var _this = this;
            if (!$("#"+_this.obj_id).hasClass("forbid_submit")) {
                
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);

                $.ajax({
                    type: 'POST',
                    url: _this.api_url,
                    data: $send_data,
                    dataType: "json",
                    success: function($data) {
                        var $json = eval($data);
                        var $response = $json.response;
                        var $result = $json.result;
                        
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        
                        if ($response == '1') {
                            if ($type == 'add') {
                                OEUI.toast({
                                    type: 'bottom',
                                    text: '发布成功'
                                });
                                setTimeout(function(){
                                    window.location.reload();
                                }, 800);
                            }
                            else if ($type == 'edit') {
                                OEUI.toast({
                                    type: 'bottom',
                                    text: '编辑成功'
                                });
                                setTimeout(function(){
                                    window.location.reload();
                                }, 800);
                            }
                            else if ($type == 'del') {
                                OEUI.toast({
                                    type: 'bottom',
                                    text: '删除成功'
                                });
                                $("#list_"+_this.id).remove();
                            }
                        }
                        else if ($response == '2') {
                            if ($type == 'add') {
                                OEUI.toast({
                                    type: 'bottom',
                                    text: '发布成功，请等待网站审核！'
                                });
                                setTimeout(function(){
                                    window.location.reload();
                                }, 800);
                            }
                            else if ($type == 'edit') {
                                OEUI.toast({
                                    type: 'bottom',
                                    text: '编辑成功，请等待网站审核！'
                                });
                                setTimeout(function(){
                                    window.location.reload();
                                }, 800);
                            }
                        }
                        
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '操作失败，请检查';
                            }
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            }); 
                        }
                    },
                    error: function () {
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        OEUI.toast({
                            type: 'bottom',
                            text: '网络繁忙，请稍后再试！'
                        });
                    }
                });
                
            }
        }
    }
    new OEDiary();
});