/**
 * [OElove] (C)2010-2099 oelove.com  biz
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/12/1 by BO $
*/

$(function () {
    function RZ () {
        this.openIdRz();
        this.openMarryRz();
        this.openMobileRz();
        this.openEmailRz();
        this.openQQRz();
        this.openWecatRz();
        this.openEduRz();
        this.openHouseRz();
        this.openCarRz();
        this.initUpload();
        this.submitMarryRz();
        this.submitMobileRz();
        this.replaceRz();
        this.submitEmailRz();
        this.submitQQRz();
        this.submitWeixinRz();
        this.submitEduRz();
        this.submitHouseRz();
        this.submitCarRz();
        this.updateEmail();
        this.updateQQ();
        this.updateMobile();
    }
    RZ.prototype = {
        openIdRz: function () {
            $('[f="open_id_rz"]').on('click', function () {
                window.idRzDialog = OEUI.modal.dialog({
                    type: 'iframe',
                    title: '实名认证',
                    content: _OE_FILE + "&c=rz&a=rz&type=idnumber",
                    width: 600,
                    height: 560
                });
            });
        },
        openMarryRz: function () {
            $('[f="open_marry_rz"]').on('click', function () {
                window.marryRzDialog = OEUI.modal.dialog({
                    type: 'iframe',
                    title: '婚况证明',
                    content: _OE_FILE + "&c=rz&a=rz&type=marry",
                    width: 600,
                    height: 500
                });
            });
        },
        openMobileRz: function () {
            $('[f="open_mobile_rz"]').on('click', function () {
                OEUI.modal.dialog({
                    type: 'iframe',
                    title: '手机认证',
                    content: _OE_FILE + "&c=rz&a=rz&type=mobile",
                    width: 600,
                    height: 500
                });
            });
        },
        openEmailRz: function () {
            $('[f="open_email_rz"]').on('click', function () {
                OEUI.modal.dialog({
                    type: 'iframe',
                    title: '邮箱认证',
                    content: _OE_FILE + "&c=rz&a=rz&type=email",
                    width: 600,
                    height: 500
                });
            });
        },
        openQQRz: function () {
            $('[f="open_qq_rz"]').on('click', function () {
                OEUI.modal.dialog({
                    type: 'iframe',
                    title: 'QQ认证',
                    content: _OE_FILE + "&c=rz&a=rz&type=qq",
                    width: 600,
                    height: 500
                });
            });
        },
        openWecatRz: function () {
            $('[f="open_wechat_rz"]').on('click', function () {
                OEUI.modal.dialog({
                    type: 'iframe',
                    title: '微信认证',
                    content: _OE_FILE + "&c=rz&a=rz&type=weixin",
                    width: 600,
                    height: 500
                });
            });
        },
        openEduRz: function () {
            $('[f="open_edu_rz"]').on('click', function () {
                window.eudRzDialog = OEUI.modal.dialog({
                    type: 'iframe',
                    title: '学历认证',
                    content: _OE_FILE + "&c=rz&a=rz&type=edu",
                    width: 600,
                    height: 500
                });
            });
        },
        openHouseRz: function () {
            $('[f="open_house_rz"]').on('click', function () {
                window.houseRzDialog = OEUI.modal.dialog({
                    type: 'iframe',
                    title: '房子认证',
                    content: _OE_FILE + "&c=rz&a=rz&type=house",
                    width: 600,
                    height: 500
                });
            });
        },
        openCarRz: function () {
            $('[f="open_car_rz"]').on('click', function () {
                window.carRzDialog = OEUI.modal.dialog({
                    type: 'iframe',
                    title: '车子认证',
                    content: _OE_FILE + "&c=rz&a=rz&type=car",
                    width: 600,
                    height: 500
                });
            });
        },
        initUpload: function () {
            if (typeof Uploader == 'undefined') return;
            var loading;
            var upload = new Uploader({
                el: document.getElementById('uploader'),
                url: _OE_FILE+"&c=index&a=upload&module=paper&thumbfiles=0&forbidwater=1",
                data: {
                  uploadpart: 'file'
                }
            });
            upload.on('beforeUpload', function (e) {
                var file = e.target.files[0];
                var regexp = /.(gif|GIF|jpg|JPG|jpeg|JPEG|png|PNG)$/;
                if (!regexp.test(file.name)) {
                    OEUI.message.msg({ text: '请上传gif|GIF|jpg|JPG|jpeg|JPEG|png|PNG格式的图片' });
                    return false;
                }
                loading = OEUI.loading({
                  el: document.getElementById('uploader'),
                  color: '#999',
                  width: 30,
                  height: 30
                });
                loading.show();
                return true;
            });
            upload.on('success', function (res) {
                $('#upload_img').attr('src', res.uploadimg);
                $('#img_url').val(res.uploadimg);
                loading.remove();
            });
            upload.on('error', function () {
                loading.remove();
            });
        },
        submitMarryRz: function () {
            var is_http = false;
            $('[f="submit_marry_rz"]').on('click', function () {
                var img = $('#img_url').val();
                if (img == '') {
                    OEUI.message.msg({text: '请上传婚况证明'});
                    return;
                }
                if (is_http) return;
                is_http = true;

                var loading,
                    timer = setTimeout(function () {
                        loading = OEUI.loading({
                            el: this
                        });
                        loading.show();
                    }, 200);

                $.ajax({
                    type: "POST",
                    url: _ROOT_PATH+"index.php?m=user&c=rz",
                    data: {
                        a:"marryrz", marryimg:img
                    },
                    success: function(json) {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        var res = JSON.parse(json);
                        if (res.response == '1') {
                            window.parent.OEUI.message.msg({text: '提交成功，请等待审核'});
                            window.parent.marryRzDialog && window.parent.marryRzDialog.remove();
                        }
                        else {
                            if (res.result.length > 0) {
                                OEUI.message.msg({text: '提交成功，请等待审核'});
                            }
                            else {
                                OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                            }
                        }
                    },
                    error: function() {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                    }
                });
            })
        },
        submitMobileRz: function () {
            var is_http = false; 
            $('[f="submit_mobile_rz"]').on('click', function () {
                var mobile = $('#mobile').val();
                var mobilecode = $('#mobile_code').val();
                if (mobile == '') {
                    OEUI.message.msg({text: '请输入手机号'});
                    return;
                }
                if (mobilecode == '') {
                    OEUI.message.msg({text: '请输入手机验证码'});
                    return;
                }

                if (is_http) return;
                is_http = true;

                var loading,
                    timer = setTimeout(function () {
                        loading = OEUI.loading({
                            el: this
                        });
                        loading.show();
                    }, 200);
                $.ajax({
                    type: "POST",
                    url: _ROOT_PATH+"index.php?m=user&c=rz",
                    data: {
                        a: "mobilerz", mobile: mobile, mobilecode: mobilecode
                    },
                    success: function(json) {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        var res = JSON.parse(json);
                        if (res.response == '1') {
                            OEUI.message.msg({text: '认证成功'});
                            setTimeout(function () {
                                window.parent.location.reload();
                            }, 800);
                        } else {
                            if (res.result.length > 0) {
                                OEUI.message.msg(res.result);
                            } else {
                                OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                            }
                        }
                    },
                    error: function() {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                    }
                });
            });
        },
        updateMobile: function () {
            var is_http = false; 
            $('[f="edit_mobile"]').on('click', function () {
                var mobile = $('#mobile').val();
                if (mobile == '') {
                    OEUI.message.msg({text: '请输入手机号码'});
                    return;
                }
                if (is_http) return;
                is_http = true;

                var loading,
                    timer = setTimeout(function () {
                        loading = OEUI.loading({
                            el: this
                        });
                        loading.show();
                    }, 200);
                $.ajax({
                    type: "POST",
                    url: _OE_FILE + "&c=rz&a=editmobile",
                    data: {mobile:mobile},
                    success: function(json) {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        var res = JSON.parse(json);
                        if (res.response == "1") {
                            OEUI.message.msg({text: '手机号码修改成功'});
                        }
                        else {
                            if (res.result.length > 0) {
                                OEUI.message.msg({text:　res.result});
                            }
                            else {
                                OEUI.message.msg({text: '手机号码修改失败'});
                            }
                        }
                    },
                    error: function() {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        OEUI.message.msg({text: '手机号码修改失败'});
                    }
                });
            });
        },
        replaceRz: function () {
            $('[f="replace_rz"]').on('click', function () {
                $('#rz_form').show();
                $('#had_rz').hide();
            });
        },
        submitEmailRz: function () {
            var is_http = false; 
            $('[f="submit_email_rz"]').on('click', function () {
                var email = $('#email').val();
                var emailcode = $('#email_code').val();
                if (email == '') {
                    OEUI.message.msg({text: '请输入邮箱号码'});
                    return;
                }
                if (emailcode == '') {
                    OEUI.message.msg({text: '请输入邮箱验证码'});
                    return;
                }

                if (is_http) return;
                is_http = true;

                var loading,
                    timer = setTimeout(function () {
                        loading = OEUI.loading({
                            el: this
                        });
                        loading.show();
                    }, 200);
                $.ajax({
                    type: "POST",
                    url: _ROOT_PATH+"index.php?m=user&c=rz",
                    data: {
                        a:"emailrz", email: email, emailcode: emailcode
                    },
                    success: function(json) {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        var res = JSON.parse(json);
                        if (res.response == '1') {
                            OEUI.message.msg({text: '认证成功'});
                            setTimeout(function () {
                                window.parent.location.reload();
                            }, 800);
                        } else {
                            if (res.result.length > 0) {
                                OEUI.message.msg(res.result);
                            } else {
                                OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                            }
                        }
                    },
                    error: function() {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                    }
                });
            });
        },
        updateEmail: function () {
            var is_http = false; 
            $('[f="edit_email"]').on('click', function () {
                var email = $('#email').val();
                if (email == '') {
                    OEUI.message.msg({text: '请输入邮箱'});
                    return;
                }
                if (is_http) return;
                is_http = true;

                var loading,
                    timer = setTimeout(function () {
                        loading = OEUI.loading({
                            el: this
                        });
                        loading.show();
                    }, 200);
                $.ajax({
                    type: "POST",
                    url: _OE_FILE + "&c=rz&a=editemail",
                    data: {email:email},
                    success: function(json) {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        var res = JSON.parse(json);
                        if (res.response == "1") {
                            OEUI.message.msg({text: '邮箱修改成功'});
                        }
                        else {
                            if (res.result.length > 0) {
                                OEUI.message.msg({text: res.result});
                            }
                            else {
                                OEUI.message.msg({text: '邮箱修改失败'});
                            }
                        }
                    },
                    error: function() {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        console.log("邮箱修改失败");
                    }
                });
            });
        },
        submitQQRz: function () {
            var is_http = false; 
            $('[f="submit_qq_rz"]').on('click', function () {
                var qq = $('#qq').val();
                var qqcode = $('#qq_code').val();
                if (qq == '') {
                    OEUI.message.msg({text: '请输入QQ号码'});
                    return;
                }
                if (qqcode == '') {
                    OEUI.message.msg({text: '请输入QQ邮箱验证码'});
                    return;
                }

                if (is_http) return;
                is_http = true;

                var loading,
                    timer = setTimeout(function () {
                        loading = OEUI.loading({
                            el: this
                        });
                        loading.show();
                    }, 200);
                $.ajax({
                    type: "POST",
                    url: _ROOT_PATH+"index.php?m=user&c=rz",
                    data: {
                        a:"qqrz", qq: qq, qqcode: qqcode
                    },
                    success: function(json) {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        var res = JSON.parse(json);
                        if (res.response == '1') {
                            OEUI.message.msg({text: '认证成功'});
                            setTimeout(function () {
                                window.parent.location.reload();
                            }, 800);
                        } else {
                            if (res.result.length > 0) {
                                OEUI.message.msg(res.result);
                            } else {
                                OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                            }
                        }
                    },
                    error: function() {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                    }
                });
            });
        },
        updateQQ: function () {
            var is_http = false; 
            $('[f="edit_qq"]').on('click', function () {
                var qq = $('#qq').val();
                if (qq == '') {
                    OEUI.message.msg({text: '请输入QQ号码'});
                    return;
                }
                if (is_http) return;
                is_http = true;

                var loading,
                    timer = setTimeout(function () {
                        loading = OEUI.loading({
                            el: this
                        });
                        loading.show();
                    }, 200);
                $.ajax({
                    type: "POST",
                    url: _OE_FILE + "&c=rz&a=editqq",
                    data: {qq:qq},
                    success: function(json) {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        var res = JSON.parse(json);
                        if (res.response == "1") {
                            OEUI.message.msg({text: 'QQ修改成功'});
                        }
                        else {
                            if (res.result.length > 0) {
                                OEUI.message.msg({text: res.result});
                            }
                            else {
                                OEUI.message.msg({text: 'QQ修改失败'});
                            }
                        }
                    },
                    error: function() {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        OEUI.message.msg({text: 'QQ修改失败'});
                    }
                });
            });
        },
        submitWeixinRz: function () {
            var is_http = false; 
            $('[f="submit_weixin_rz"]').on('click', function () {
                var weixin = $('#weixin').val();
                if (weixin == '') {
                    OEUI.message.msg({text: '请输入微信号码'});
                    return;
                }

                if (is_http) return;
                is_http = true;

                var loading,
                    timer = setTimeout(function () {
                        loading = OEUI.loading({
                            el: this
                        });
                        loading.show();
                    }, 200);
                $.ajax({
                    type: "POST",
                    url: _ROOT_PATH+"index.php?m=user&c=rz",
                    data: {
                        a:"saveweixin", weixin: weixin
                    },
                    success: function(json) {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        var res = JSON.parse(json);
                        if (res.response == '1') {
                            OEUI.message.msg({text: '认证成功'});
                            setTimeout(function () {
                                window.parent.location.reload();
                            }, 800);
                        } else {
                            if (res.result.length > 0) {
                                OEUI.message.msg(res.result);
                            } else {
                                OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                            }
                        }
                    },
                    error: function() {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                    }
                });
            });
        },
        submitEduRz: function () {
            var is_http = false;
            $('[f="submit_edu_rz"]').on('click', function () {
                var img = $('#img_url').val();
                if (img == '') {
                    OEUI.message.msg({text: '请上传学历证明'});
                    return;
                }
                if (is_http) return;
                is_http = true;

                var loading,
                    timer = setTimeout(function () {
                        loading = OEUI.loading({
                            el: this
                        });
                        loading.show();
                    }, 200);

                $.ajax({
                    type: "POST",
                    url: _ROOT_PATH+"index.php?m=user&c=rz",
                    data: {
                        a:"edurz", eduimg:img
                    },
                    success: function(json) {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        var res = JSON.parse(json);
                        if (res.response == '1') {
                            window.parent.OEUI.message.msg({text: '提交成功，请等待审核'});
                            window.parent.eudRzDialog && window.parent.eudRzDialog.remove();
                        }
                        else {
                            if (res.result.length > 0) {
                                OEUI.message.msg({text: '提交成功，请等待审核'});
                            }
                            else {
                                OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                            }
                        }
                    },
                    error: function() {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                    }
                });
            })
        },
        submitHouseRz: function () {
            var is_http = false;
            $('[f="submit_house_rz"]').on('click', function () {
                var img = $('#img_url').val();
                if (img == '') {
                    OEUI.message.msg({text: '请上传房产证明'});
                    return;
                }
                if (is_http) return;
                is_http = true;

                var loading,
                    timer = setTimeout(function () {
                        loading = OEUI.loading({
                            el: this
                        });
                        loading.show();
                    }, 200);

                $.ajax({
                    type: "POST",
                    url: _ROOT_PATH+"index.php?m=user&c=rz",
                    data: {
                        a:"houserz", houseimg:img
                    },
                    success: function(json) {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        var res = JSON.parse(json);
                        if (res.response == '1') {
                            window.parent.OEUI.message.msg({text: '提交成功，请等待审核'});
                            window.parent.houseRzDialog && window.parent.houseRzDialog.remove();
                        }
                        else {
                            if (res.result.length > 0) {
                                OEUI.message.msg({text: '提交成功，请等待审核'});
                            }
                            else {
                                OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                            }
                        }
                    },
                    error: function() {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                    }
                });
            })
        },
        submitCarRz: function () {
            var is_http = false;
            $('[f="submit_car_rz"]').on('click', function () {
                var img = $('#img_url').val();
                if (img == '') {
                    OEUI.message.msg({text: '请上传购车证明'});
                    return;
                }
                if (is_http) return;
                is_http = true;

                var loading,
                    timer = setTimeout(function () {
                        loading = OEUI.loading({
                            el: this
                        });
                        loading.show();
                    }, 200);

                $.ajax({
                    type: "POST",
                    url: _ROOT_PATH+"index.php?m=user&c=rz",
                    data: {
                        a:"carrz", carimg:img
                    },
                    success: function(json) {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        var res = JSON.parse(json);
                        if (res.response == '1') {
                            window.parent.OEUI.message.msg({text: '提交成功，请等待审核'});
                            window.parent.carRzDialog && window.parent.carRzDialog.remove();
                        }
                        else {
                            if (res.result.length > 0) {
                                OEUI.message.msg({text: '提交成功，请等待审核'});
                            }
                            else {
                                OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                            }
                        }
                    },
                    error: function() {
                        is_http = false;
                        loading && loading.remove();
                        clearTimeout(timer);
                        timer = null;
                        OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                    }
                });
            })
        }
    }
    new RZ();
});
