/**
 * [OElove] (C)2010-2099 oelove.com  biz
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/11/11 by BO $
*/
(function () {
    if (!Array.prototype.forEach) {

      Array.prototype.forEach = function(callback/*, thisArg*/) {
    
        var T, k;
    
        if (this == null) {
          throw new TypeError('this is null or not defined');
        }
    
        // 1. Let O be the result of calling toObject() passing the
        // |this| value as the argument.
        var O = Object(this);
    
        // 2. Let lenValue be the result of calling the Get() internal
        // method of O with the argument "length".
        // 3. Let len be toUint32(lenValue).
        var len = O.length >>> 0;
    
        // 4. If isCallable(callback) is false, throw a TypeError exception. 
        // See: http://es5.github.com/#x9.11
        if (typeof callback !== 'function') {
          throw new TypeError(callback + ' is not a function');
        }
    
        // 5. If thisArg was supplied, let T be thisArg; else let
        // T be undefined.
        if (arguments.length > 1) {
          T = arguments[1];
        }
    
        // 6. Let k be 0.
        k = 0;
    
        // 7. Repeat while k < len.
        while (k < len) {
    
          var kValue;
    
          // a. Let Pk be ToString(k).
          //    This is implicit for LHS operands of the in operator.
          // b. Let kPresent be the result of calling the HasProperty
          //    internal method of O with argument Pk.
          //    This step can be combined with c.
          // c. If kPresent is true, then
          if (k in O) {
    
            // i. Let kValue be the result of calling the Get internal
            // method of O with argument Pk.
            kValue = O[k];
    
            // ii. Call the Call internal method of callback with T as
            // the this value and argument list containing kValue, k, and O.
            callback.call(T, kValue, k, O);
          }
          // d. Increase k by 1.
          k++;
        }
        // 8. return undefined.
      };
    }

    // Production steps of ECMA-262, Edition 5, 15.4.4.17
    // Reference: http://es5.github.io/#x15.4.4.17
    if (!Array.prototype.some) {
      Array.prototype.some = function(fun/*, thisArg*/) {
        'use strict';

        if (this == null) {
          throw new TypeError('Array.prototype.some called on null or undefined');
        }

        if (typeof fun !== 'function') {
          throw new TypeError();
        }

        var t = Object(this);
        var len = t.length >>> 0;

        var thisArg = arguments.length >= 2 ? arguments[1] : void 0;
        for (var i = 0; i < len; i++) {
          if (i in t && fun.call(thisArg, t[i], i, t)) {
            return true;
          }
        }

        return false;
      };
    }

    /**
     * @param {el, data, url, color, width, height, bgColor} options 
     * @function on 绑定事件
     */
    function OEUploader (options) {
        var option = {
            color: '#999',
            width: 30,
            height: 30,
            bgColor: '#fff'
        };
        this.events = {};
        this.option = $.extend({}, option, options);
        this.el = typeof options.el == 'object' ? options.el: document.querySelector(options.el);
        
        this.initUploader();
    }
    OEUploader.prototype = {
        on: function (name, cb){ 
            if(this.events [name]){ 
                this.events [name].push(cb); 
            } else { 
                this.events [name] = [cb]; 
            } 
        },
        callHook: function (name, arg){ 
            if(this.events [name]){ 
                var result = [];
                this.events [name] .forEach(function (eventListener) { 
                    var res = eventListener(arg); 
                    result.push(res);
                }); 
                if(result.some( function (v) {return v === false;})) {
                    return false;
                } else {
                    return true;
                }
            } 
            return true;
        },
        
        initUploader: function () {
            var _this = this;
            if (typeof Uploader == 'undefined') return;
            var loading;
            var upload = new Uploader({
                el: this.el,
                url: this.option.url,
                data: this.option.data,
                multiple:this.option.multiple
            });
            upload.on('beforeUploadOption', function () {
                return _this.callHook('beforeUploadOption');
            });
            upload.on('beforeUpload', function (e) {
                var file = e.target.files ? e.target.files[0]: e.dataTransfer.files[0];
                var beforeUpload = _this.callHook('beforeUpload', e);
                if(!beforeUpload) {
                    return false;
                }
                var regexp = /.(gif|GIF|jpg|JPG|jpeg|JPEG|png|PNG)$/;
                if (!regexp.test(file.name)) {
                    OEUI.message.msg({ text: '请上传gif|GIF|jpg|JPG|jpeg|JPEG|png|PNG格式的图片' });
                    return false;
                }
                loading = OEUI.loading({
                    el: _this.el,
                    color: _this.option.color,
                    width: _this.option.width,
                    height: _this.option.height,
                    bgColor: _this.option.bgColor
                });
                loading.show();
                return true;
            });
            upload.on('success', function (res) {
                _this.callHook('success', res);
                loading.remove();
            });
            upload.on('error', function () {
                _this.callHook('error');
                loading.remove();
            });
        },
    }
    window.OEUploader = OEUploader;
})();
