/**
 * [OElove] (C)2010-2099 OElove.com
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/11/10 by BO $
*/
$(function () {
    function Diary () {
        this.openAddDialog();  
        this.openEditDialog(); 
        this.del();
    }
    Diary.prototype = {
        openAddDialog: function () {
            $('[f="open_add_dialog"]').on('click', function () {
                OEUI.modal.dialog({
                    type: 'iframe',
                    title: '发布日记',
                    width: 800,
                    height: 580,
                    content: _ROOT_PATH+"index.php?m=user&c=diary&a=add"
                });
            });
        },
        openEditDialog: function () {
            $('[f="open_edit_dialog"]').on('click', function () {
                var id = $(this).attr('data-id');
                OEUI.modal.dialog({
                    type: 'iframe',
                    title: '编辑日记',
                    width: 800,
                    height: 580,
                    content: _ROOT_PATH + "index.php?m=user&c=diary&a=edit&id=" + id
                });
            });
        },
        del: function () {
            $('[f="del_diary"]').on('click', function () {
                var id = $(this).attr('data-id');

                OEUI.modal.info({
                    title: '温馨提示',
                    text: '是否要删除该日记？',
                    confirm: function () {
                        $.ajax({
                            type: "POST",
                            url: _OE_FILE + "&c=diary",
                            data: {
                                a:"del", id:id, datatype:"json"
                            },
                            success: function(json) {
                                var res = JSON.parse(json);
                                if (res.response == "1") {
                                    OEUI.message.msg({text: '删除成功'});
                                    setTimeout(function () {
                                        location.reload();
                                    }, 800);
                                } else {
                                    if (res.result.length > 0) {
                                        OEUI.message.msg({text: res.result});
                                    } else {
                                        OEUI.message.msg({text: '删除失败'});
                                    }
                                }
                            },
                            error: function() {
                                OEUI.message.msg({text: '系统繁忙，请稍后再试'});
                            }
                        });
                    }
                });
            });
        }
    }
    new Diary();
});