/**
 * [OElove] (C)2010-2099 oelove.com biz
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/11/12 by BO $
*/
$(function () {
      function Forget () {
          this.switch();
          this.submit();
          this.submitEditPwd();
      }
      Forget.prototype = {
          switch: function () {
              $('[f="switch_type"]').on('change', function () {
                  var type = $('[name="gettype"]:checked').val();
                  if (type == 'mobile') {
                      $('#email_box').hide();
                      $('#mobile_box').show();
                  } else {
                      $('#email_box').show();
                      $('#mobile_box').hide();
                  }
              });
          },
          submit: function () {
              var _this = this;
              $('[f="submit"]').on('click', function () {
                  var type = $('[name="gettype"]:checked').val();
                  if (type == 'mobile') {
                      _this.submitMobile();
                  } else {
                      _this.submitEmail();
                  }
              });
          },
          submitMobile: function () {
              var val = $('#mobile').val();
              var code = $('#mobile_code').val();
              if (val == '') {
                  OEUI.message.msg({text: '请输入手机号码'});
                  return;
              }
              if (code == '') {
                  OEUI.message.msg({text: '请输入验证码'});
                  return;
              }
              $.ajax({
                  type: "POST",
                  url: _ROOT_PATH + "index.php?c=picker",
                  data: {
                      a:"check", check_type:"mobilecode", name: val, checkcode: code
                  },
                  success: function(json) {
                      var res = JSON.parse(json);
                      if (res.response == "1") { //校验成功
                          $('#eidt_box').show().siblings('.form_box').hide();
                          $('#mobile_box').hide();
                          $('#email_box').hide();
                      } else {
                          if (res.result.length > 0) {
                              OEUI.message.msg({text: res.result});
                          } else {
                              OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                          }
                      }
                  },
                  error: function() {
                      OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                  }
              });    
          },
          submitEmail: function () {
              var val = $("#email").val();
              var code = $('#email_code').val();
              $.ajax({
                  type: "POST",
                  url: _ROOT_PATH + "index.php?c=picker",
                  data: {
                      a: "check", check_type: "emailcode", name: val, checkcode: code
                  },
                  success: function(json) {
                      var res = JSON.parse(json);
                      if (res.response == "1") { //校验成功
                          $('#mobile_box').hide();
                          $('#mobile_box').hide();
                          $('#eidt_box').show().siblings('.form_box').hide();
                      } else {
                          if (res.result.length > 0) {
                              OEUI.message.msg({text: res.result});
                          } else {
                              OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                          }
                      }
                  },
                  error: function() {
                      OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                  }
              }); 
          },
          submitEditPwd: function () {
              var _this = this;
              $('[f="submit_eidt_password"]').on('click', function () {
                  var gettype = $("[name='gettype']:checked").val() || 'mobile';
                  var type = '' , name = '', validcode = '', password = '', confirmpwd = '';
            
                  if (gettype == "mobile") {
                      type = 2; //手机取回
                      name = $("#mobile").val();
                      validcode = $("#mobile_code").val();
                      password = $("#newpassword").val();
                      confirmpwd = $("#confirmpassword").val() || '';
                      
                      if (name == '') {
                          OEUI.message.msg({text: '请填写手机号'});
                          return false;
                      }
                      if (validcode == '') {
                          OEUI.message.msg({text: '请填写手机验证码'});
                          return false;
                      }
                  } else {
                      type = 1; //邮箱取回
                      name = $("#email").val();
                      validcode = $("#email_code").val();
                      password = $("#newpassword").val() || '';
                      //0.05.19
                      confirmpwd = $("#confirmpassword").val() || '';
                      
                      if (name == '') {
                          OEUI.message.msg({text: '请填写邮箱'});
                          return false;
                      }
                      if (validcode == '') {
                          OEUI.message.msg({text: '请填写邮箱验证码'});
                          return false;
                      }
                  }
                  if (password.length == 0) {
                      OEUI.message.msg({text: '请设置6-16个字符的新密码'});
                      return false;
                  }
                  
                  //0.05.19
                  if (confirmpwd == '') {
                      OEUI.message.msg({text: '请再次填写新密码'});
                      return false;
                  }
                  if (confirmpwd != password) {
                      OEUI.message.msg({text: '两次输入的不一致，请重新输入'});
                      return false;
                  }
                  
                  if (is_http) return;
                  is_http = true;

                  var loading,
                      timer = setTimeout(function () {
                          loading = OEUI.loading({
                              el: this
                          });
                          loading.show();
                      }, 200);

                  $.ajax({
                      type: "POST",
                      url: _ROOT_PATH + "index.php?c=passport",
                      data: {
                          a:"setpassword", type: type, name: name, validcode: validcode, password: password
                      },
                      success: function(json) {
                          is_http = false;
                          loading && loading.remove();
                          clearTimeout(timer);
                          timer = null;
                          var res = JSON.parse(json);
                          if (res.response == "1") { //成功，返回页面
                              OEUI.message.msg({text: '操作成功，请记住新密码！'});
                              setTimeout(function(){
                                  window.location.href = _ROOT_PATH+"index.php?c=passport&a=login&nofollow=1";		
                              }, 1000);                        			
                          } else {
                              if (res.result == '') {
                                  OEUI.message.msg(res.result);
                              }
                              else {
                                  OEUI.message.msg({text: '取回密码失败，请检查！'});
                              }
                          }
                      },
                      error: function() {
                          is_http = false;
                          loading && loading.remove();
                          clearTimeout(timer);
                          timer = null;
                          OEUI.message.msg({text: '系统繁忙，请稍后再试'});
                      }
                  }); 
              });
          }
      }
      new Forget();
});
