/**
 * [OElove] (C)2010-2099 oelove.com biz
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 *  Last update 2020/11/06 by BO 
*/
$(function () {
    function Report () {
        this.initUpload();
        this.removeImg();
        this.submit();
    }
    Report.prototype = {
        initUpload: function () {
            var loading;
            var upload = new Uploader({
                el: document.getElementById('uploader'),
                url: _ROOT_PATH+"index.php?c=index&a=upload&forbidcom=1&forbidwater=1&module=upload",
                data: {
                  uploadpart: 'file'
                }
            });
            upload.on('beforeUpload', function (e) {
                var file = e.target.files[0];
                var regexp = /.(gif|GIF|jpg|JPG|jpeg|JPEG|png|PNG)$/;
                if (!regexp.test(file.name)) {
                    OEUI.message.msg({ text: '请上传gif|GIF|jpg|JPG|jpeg|JPEG|png|PNG格式的图片' });
                    return false;
                }
                loading = OEUI.loading({
                  el: document.getElementById('uploader'),
                  color: '#999',
                  width: 30,
                  height: 30
                });
                loading.show();
                return true;
            });
            upload.on('success', function (res) {
                var html = '\
                  <div class="img_60 bo_eb bg_f5 fl mr10 pr img_box">\
                    <div class="w100per h100per oh">\
                      <img class="ob_c" src="'+ res.uploadimg +'" f="upload_img">\
                    </div>\
                    <div class="pa cursor t_5" style="right: -5px;" f="remove_img">\
                      <em class="iconfont icon-yichu color_red lhn"></em>\
                    </div>\
                  </div>\
                ';
                $('#uploader').before(html);
                loading.remove();
            });
            upload.on('error', function () {
                loading.remove();
            });
        },
        removeImg: function () {
            $(document).on('click', '[f="remove_img"]', function () {
                var target = $(this);
                OEUI.modal.info({
                    title: '温馨提示',
                    text: '是否删移除该图片？',
                    confirm: function () {
                        target.closest('.img_box').remove();
                    }
                });
            });
        },
        submit: function () {
            var is_http = false;
            $('[f="report"]').on('click', function () {
                var jubao_homeuid = $("#jubao_homeuid").val();
                var jubao_blacktype = $("#jubao_blacktype").val();
                var jubao_judes = $("#jubao_judes").val();
                var jubao_juimg = $("#jubao_juimg").val();
                var jubao_jumobile = $("#jubao_jumobile").val();
                var jubao_juemail = $("#jubao_juemail").val();
        
                if (jubao_homeuid == '') {
                    OEUI.message.msg({text: '举报对象UID错误'});
                    return false;
                }
                if (jubao_blacktype == '') {
                    OEUI.message.msg({text: '请选择举报类型'});
                    return false;
                }
                if (jubao_judes == '') {
                    OEUI.message.msg({text: '请填写举证描述'});
                    return false;
                }
                if (jubao_jumobile == '') {
                    OEUI.message.msg({text: '请填写举报人手机'});
                    return false;
                }
                var jubao_juimg = [];
                var img = $('[f="upload_img"]');
                $.each(img, function (i, v) {
                    jubao_juimg.push($(v).attr('src'));
                });

                if (is_http) return;
                is_http = true;

                var loading, timer, el = this;
                timer = setTimeout(function () {
                    loading = OEUI.loading({
                        el: el,
                        color: '#666'
                    });
                    loading.show();
                }, 200); 


                $.ajax({
                    type: 'POST',
                    url:  _ROOT_PATH + "index.php?c=jubao",
                    data: {
                        a:"savejubao", 
                        homeuid: jubao_homeuid, 
                        blacktype: jubao_blacktype, 
                        judes: jubao_judes, 
                        juimg: jubao_juimg.join(','), 
                        jumobile: jubao_jumobile, 
                        juemail: jubao_juemail
                    },
                    success: function (json) {
                        is_http = false;
                        clearTimeout(timer);
                        timer = null;
                        loading &&　loading.remove();

                        var res = JSON.parse(json);
                        if (res.response == '1') {
                            window.parent.OEUI.message.msg({text: '举报/投诉提交成功，请等待审核！'});
                            setTimeout(function () {
                                window.parent.report_dialog &&　window.parent.report_dialog.remove();
                            }, 500);
                        } else {
                            if (res.result) {
                                OEUI.messag.msg({text: res.result});
                            } else {
                                OEUI.messag.msg({text: '网络繁忙，请稍后再试'});
                            }
                        }
                    },
                    error: function () {
                        is_http = false;
                        clearTimeout(timer);
                        timer = null;
                        loading &&　loading.remove();
                        OEUI.messag.msg({text: '网络繁忙，请稍后再试'});
                    }
                });
            });
        }
    }
    new Report();
});