<?php
/**
 * Copyright (C) OElove Webapp All rights reserved.
 * <E-Mail：service@phpcoo.com>
 * Url http://www.phpcoo.com
 *     http://www.oephp.com
 *     http://www.oelove.com
 * Update 2016.12.05
 */
if (!defined('IN_OELOVE')) {
    exit('OElove[OEPHP] Access Denied');
}
/**
 * 
 * 回调基础类
 * @author widyhu
 *
 */
class WxPayNotify extends WxPayNotifyReply {
	/**
	 * 
	 * 回调入口
	 * @param bool $needSign  是否需要签名输出
     * @param bool $echo 是否输出XML代码 true-Y,false-F return
	 */
	final public function Handle($needSign = true, $echo = false) {
		$msg = "OK";
		//当返回false的时候，表示notify中调用NotifyCallBack回调失败获取签名校验失败，此时直接回复失败
		$result = WxpayApi::notify(array($this, 'NotifyCallBack'), $msg);

		if ($result == false){ //支付错误 失败
			$this->SetReturn_code("FAIL");
			$this->SetReturn_msg($msg);
            if (true === $echo) {
                echo $this->ReplyNotify(false);
            }
            else {
                return $this->ReplyNotify(false);
            }
		}
        else { //该分支在成功回调到NotifyCallBack方法，处理完成之后流程 成功
			$this->SetReturn_code("SUCCESS");
			$this->SetReturn_msg("OK");
            if (true === $echo) {
                echo $this->ReplyNotify($needSign);
            }
            else {
                return $this->ReplyNotify($needSign);
            }
		}
	}
	
	/**
	 * 
	 * 回调方法入口，子类可重写该方法
	 * 注意：
	 * 1、微信回调超时时间为2s，建议用户使用异步处理流程，确认成功之后立刻回复微信服务器
	 * 2、微信服务器在调用失败或者接到回包为非确认包的时候，会发起重试，需确保你的回调是可以重入
	 * @param array $data 回调解释出的参数
	 * @param string $msg 如果回调处理失败，可以将错误信息输出到该方法
	 * @return true回调出来完成不需要继续回调，false回调处理未完成需要继续回调
	 */
	public function NotifyProcess($data, &$msg)
	{
		//TODO 用户基础该类之后需要重写该方法，成功的时候返回true，失败返回false
		return true;
	}
	
	/**
	 * 
	 * notify回调方法，该方法中需要赋值需要输出的参数,不可重写
	 * @param array $data
	 * @return true回调出来完成不需要继续回调，false回调处理未完成需要继续回调
	 */
	final public function NotifyCallBack($data)
	{
		$msg = "OK";
		$result = $this->NotifyProcess($data, $msg);
		
		if($result == true){
			$this->SetReturn_code("SUCCESS");
			$this->SetReturn_msg("OK");
		} else {
			$this->SetReturn_code("FAIL");
			$this->SetReturn_msg($msg);
		}
		return $result;
	}
	
	/**
	 * 
	 * 回复通知
	 * @param bool $needSign 是否需要签名输出
	 */
	final private function ReplyNotify($needSign = true) {
		if($needSign == true && $this->GetReturn_code($return_code) == "SUCCESS") { //需要签名
			$this->SetSign(); //return
		}
        $to_xml = $this->ToXml();
        return $to_xml;
	}
}