/*
 * Decompiled with CFR 0.152.
 */
package com.crack.me.active.ui.find;

import com.crack.me.active.ui.find.AbstractFinder;
import com.crack.me.active.ui.find.AbstractSignatureVerifierFinder;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecialSignatureVerifierFinder
extends AbstractSignatureVerifierFinder {
    private ClassLoader classLoader = null;
    private static final String FOR_HEAD = "com.genuitec";

    public void findJar(File fileFolder, List<File> files) {
        this.classLoader = this.getClassLoader(fileFolder);
        for (File file : files) {
            this.isSignatureVerifierFile(file);
        }
    }

    @Override
    public boolean findSignatureVerifier(File fileOrFolder) {
        this.classLoader = this.getClassLoader(fileOrFolder);
        return super.findSignatureVerifier(fileOrFolder);
    }

    @Override
    public boolean isSignatureVerifierFile(File file) {
        return this.isAllowedCheckedFile(file) ? this.isSignatureVerifierFile(this.classLoader, file) : false;
    }

    public boolean isSignatureVerifierFile(ClassLoader classLoader, File file) {
        boolean isSignatureVerifierFile = false;
        if (file != null && classLoader != null) {
            try {
                JarFile jarFile = new JarFile(file);
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    String className;
                    JarEntry jarEntry = jarEntries.nextElement();
                    if (!this.isClassFile(jarEntry) || !this.isAllowedCheckedClass(className = this.getClassName(jarEntry))) continue;
                    isSignatureVerifierFile |= this.isSignatureVerifierClass(classLoader, className);
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        return isSignatureVerifierFile;
    }

    private boolean isAllowedCheckedClass(String className) {
        return className != null && className.startsWith(FOR_HEAD);
    }

    private boolean isAllowedCheckedFile(File file) {
        return file != null && file.getAbsolutePath().indexOf(FOR_HEAD) != -1;
    }

    public ClassLoader getClassLoader(File file) {
        List<File> allFiles = this.getJarFiles(file);
        if (allFiles != null && allFiles.size() != 0) {
            URL[] urls = new URL[allFiles.size()];
            int i2 = 0;
            while (i2 < urls.length) {
                try {
                    urls[i2] = allFiles.get(i2).toURI().toURL();
                }
                catch (MalformedURLException e2) {
                    e2.printStackTrace();
                }
                ++i2;
            }
            return new URLClassLoader(urls, this.getClass().getClassLoader());
        }
        return null;
    }

    public boolean isSignatureVerifierClass(ClassLoader classLoader, String className) {
        try {
            Class<?> clazz = classLoader.loadClass(className);
            if (this.isSignatureVerifierMethods(clazz)) {
                System.out.println(className);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private boolean isClassFile(JarEntry jarEntry) {
        return jarEntry != null ? jarEntry.getName().endsWith(".class") : false;
    }

    private String getClassName(JarEntry jarEntry) {
        if (jarEntry != null) {
            String name = jarEntry.getName();
            name = name.substring(0, name.indexOf(".class"));
            name = name.replaceAll("/", ".");
            return name;
        }
        return null;
    }

    public boolean isSignatureVerifierMethods(Class<?> clazz) {
        try {
            clazz.getDeclaredMethod("verifyJarSignatures", String.class, String.class);
            clazz.getDeclaredMethod("verifyJarSignatures", String[].class);
            clazz.getDeclaredMethod("verifyJarSignatures", new Class[0]);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void main(String[] args) {
        SpecialSignatureVerifierFinder finder = new SpecialSignatureVerifierFinder();
        ((AbstractFinder)finder).find(new File("/Applications/DeveloperTools/MyEclipse_101/Common/plugins"));
    }
}

