local MakePlayerCharacter = require "prefabs/player_common"

local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/coraline.zip" ),
		Asset( "ANIM", "anim/coraline_but.zip" ),
}
local prefabs = {"pruners"}

local start_inv = {"pruners"}

local function buttoneyes(inst)

	if inst.components.sanity:IsSane() then
		inst.AnimState:SetBuild("coraline")
	else
		inst.AnimState:SetBuild("coraline_but")
	end
	
end

local function doraincoat(inst, dt)

    if GetSeasonManager() and GetSeasonManager():IsRaining() then
		inst.components.sanity.dapperness = TUNING.DAPPERNESS_MED*1.5* GetSeasonManager():GetPrecipitationRate()
    else 
		inst.components.sanity.dapperness = 0
	end
	
end

local fn = function(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "wendy"

	-- a minimap icon must be specified
	inst.MiniMapEntity:SetIcon( "willow.png" )
	
	inst.components.combat.damagemultiplier = 1.1
	inst.components.sanity:SetMax(TUNING.WILSON_SANITY * 0.8)
	inst.components.hunger:SetMax(TUNING.WILSON_HUNGER * 0.8)
	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.2)
	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.2)
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.8)
	inst.components.sanity.dapperness = 0

	-- todo: Add an example special power here.
	
	TUNING.SEEDS_GROW_TIME = 4*TUNING.SEEDS_GROW_TIME/5
	TUNING.FARM1_GROW_BONUS = TUNING.FARM1_GROW_BONUS/2
	TUNING.FARM2_GROW_BONUS = TUNING.FARM1_GROW_BONUS/2
	TUNING.FARM3_GROW_BONUS = TUNING.FARM1_GROW_BONUS/2
	TUNING.POOP_FERTILIZE = TUNING.POOP_FERTILIZE*1.5
	TUNING.POOP_SOILCYCLES = TUNING.POOP_SOILCYCLES*1.5
	TUNING.GUANO_FERTILIZE = TUNING.GUANO_FERTILIZE*1.5
	TUNING.GUANO_SOILCYCLES = TUNING.GUANO_SOILCYCLES*1.5
	
	inst:DoPeriodicTask(1/10, function() doraincoat(inst, 1/10) end)
	
	inst:ListenForEvent("goinsane", buttoneyes)
	inst:ListenForEvent("gosane", buttoneyes)
	
end



-- strings! Any "WOD" below would have to be replaced by the prefab name of your character.

-- First up, the character select screen lines 
-- note: these are lower-case character name
STRINGS.CHARACTER_TITLES.coraline = "        "
STRINGS.CHARACTER_NAMES.coraline = "Coraline"
STRINGS.CHARACTER_DESCRIPTIONS.coraline = "*    .\n*   ԰  .\n*  һ ˫  ֦  ."
STRINGS.CHARACTER_QUOTES.coraline = "\" ֻ   ƽ     \""

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE charcacter name
STRINGS.CHARACTERS.CORALINE = require "speech_coraline"

return MakePlayerCharacter("coraline", prefabs, assets, fn, start_inv)
