

require 'System.Xml, Version=2.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089'

class System::Xml::XmlReader
  include System::Xml
#  include System::Xml

  # loads a text file and begins processing in in a rubonic way (if a block was passed in
  # then the block is executed and the reader closed when finished)
  def XmlReader.load_file(file)
    stream_reader = System::IO::File.open_text(file)
    xml_reader = System::Xml::XmlReader.create(stream_reader)

    if block_given?
      begin
        yield xml_reader
      ensure
        xml_reader.close
        stream_reader.close
      end
      nil
    else
      xml_reader
    end
  end
  
  # calls Read on the XmlReader and forwards the reader to the yield proc
  def each
    while self.read
      yield
    end
  end
  
end