
require 'char'

module Mangle

  # converts a_b_c to ABC and my_simple_name to MySimpleName. It is the inverse of mangel name
  def Mangle.unmangle_name(name)
    # m[-1..-1] means the last character but as a string
    name.gsub(/(^[a-z]|_[a-z])/) {|m| m[-1..-1].upcase }
  end
  
  # converts ABC to a_b_c and MySampleName to my_sample_name
  def Mangle.mangle_name(name)
    #msg_box(name)
    is_first = true
    mangled = name.gsub(/[A-Z]/) do |s|
      if is_first 
        is_first = false
        s.downcase
      else
        '_' + s.downcase
      end
    end
    mangled
  end
  
  def Mangle.is_mangled?(name)
    Char.is_lower?(name[0])
  end
  
end