require 'set'

include System::Collections
include System::Collections::Generic

class Array
	# converts a ruby array to a c# array
	def to_clr_array_of_type(type)
		return_val = System::Array.of(type).new(length)
		0.upto(length - 1) { |i| return_val[i] = self[i] }
		return_val
	end

	def to_clr_array
		to_clr_array_of_type(self[0].class)
	end

	def to_clr_list_of_type(type)
		return_val = List.of(type).new(length)
		0.upto(length - 1) { |i| return_val.add(self[i]) }
		return_val
	end

	def to_clr_list
		to_clr_list_of_type(self[0].class)
	end
end

class Set
	def to_clr_list_of_type(type)
		return_val = List.of(type).new(length)
		self.each { |o| 
			return_val.add(o)
		}

		return_val
	end

	def to_clr_list
		self.each { |o|
			first = o
			break
		}
		to_clr_list_of_type(first.class)
	end
end
