require 'aml'
require 'axure_enumerable'
require 'Model'
require 'interop'

include Axure::Platform::Controls
include Axure::Platform::Drawing

include Axure::DocumentModel

class WizardControl < AML::Control
	attr_reader :dialog_info

  def dialog_info=(info)
    @dialog_info = info
    @dialog_info.default_button = nil
    command_key_pressed.add(lambda { |sender, e| do_command_key_press(sender, e) })
  end

  def do_command_key_press(sender, e)
    next_button_click(nil, nil) if(e.key_data == AxKeys.enter && @current_wizard_step.can_next)
  end

	def initialize()
		@step_to_prev_step = Hash.new
		@step_to_next_step = Hash.new

		#allow AlignPadLayouPanel to size up to its containing control
		self.auto_size = true
		initialize_component("dialogs/wizard/wizard_control.aml")
	end

	def current_wizard_step=(wizard_step)

	 	if @current_wizard_step
			@current_wizard_step.save_step()
			@current_wizard_step.wizard_control = nil
		end

		@current_wizard_step=wizard_step

		if @current_wizard_step
			#@step_container.add_control(@current_wizard_step)

    	@current_wizard_step.set_attached_property(GridLayoutPanel.ROW, 1)

			@gridlayout.add_control(@current_wizard_step)

			@next_button.visible = wizard_step.show_next
			@next_button.enabled = wizard_step.can_next
			@finish_button.visible = wizard_step.show_finish
			@finish_button.enabled = wizard_step.can_finish
			@previous_button.visible = wizard_step.show_previous


			@current_wizard_step.can_next_changed = lambda {
				@next_button.enabled = @current_wizard_step.can_next
			}

			@current_wizard_step.can_finish_changed = lambda {
				@finish_button.enabled = @current_wizard_step.can_finish
			}

			@current_wizard_step.wizard_control = self
#			@current_wizard_step.focus()
		end

		@header_panel.invalidate()
	end

	def get_step(step_class)
		#create one or return an existing one
		step_var_sym = "@#{step_class}".to_sym

		step_val = instance_variable_get(step_var_sym)

	 	if !step_val
			step_val = instance_variable_set(step_var_sym, step_class.new)
		end

		return step_val
	end


	def header_panel_paint(s, e)
		gfx = e.graphics
    hRect = @header_panel.DisplayRectangle

		# draw the background
		#color1 = AxColor.FromArgb(170, 184, 210)
		#color2 = AxColor.FromArgb(38, 70, 131)
		#color3 = AxColor.FromArgb(14, 44, 108)
		#color4 = AxColor.FromArgb(37, 68, 159)

		#midHeight = hRect.Height / 2
		#rectTop = AxRectangleF.new(0, 0, hRect.Width, midHeight)
		#rectBottom = AxRectangleF.new(0, midHeight, hRect.Width, hRect.Height - midHeight)

		#lgb = AxLinearGradientBrush.new(rectTop, color1, color2, 90)
		#gfx.FillRectangle(lgb, rectTop)

		#lgb = AxLinearGradientBrush.new(rectBottom, color3, color4, 90)
		#gfx.FillRectangle(lgb, rectBottom)

		if @current_wizard_step
			#draw the text.
			titleRect = AxRectangleF.new(hRect.X + 10, hRect.Y + 10, hRect.Width - 10, hRect.Height - 10)
			descRect = AxRectangleF.new(hRect.X + 10, hRect.Y + 29, hRect.Width - 15, hRect.Height - 28)

			titleText = @current_wizard_step.title

			titleFont = AxFont.new(AxPlatform.Theme.GeneralFontName, AxPlatform.Theme.GeneralFontSize, AxFontStyle.Bold)
			#gfx.DrawString(titleText, titleFont, AxBrushes.Black, AxRectangleF.new(
			#	titleRect.X + 1, titleRect.Y + 1, titleRect.Width, titleRect.Height))
			gfx.DrawString(titleText, titleFont, AxBrushes.Black, titleRect)

			descFont = AxFont.new(AxPlatform.Theme.GeneralFontName, AxPlatform.Theme.GeneralFontSize)
			gfx.DrawString(@current_wizard_step.description, descFont, AxBrushes.Black, descRect)
		end
	end

	def previous_button_click(s, e)
		self.current_wizard_step = self.get_previous_wizard_step()
	end

	def next_button_click(s, e)
		if @current_wizard_step.verify
			self.current_wizard_step = self.get_next_wizard_step()
		end
	end

	def finish_button_click(s, e)
		@current_wizard_step.save_step()
		@dialog_info.click_ok if @current_wizard_step.verify
	end

	def cancel_button_click(s, e)
		@dialog_info.click_cancel
	end

	def get_previous_wizard_step
		cls = @step_to_prev_step[@current_wizard_step.class]
		return get_step(cls) if cls
	end

	def get_next_wizard_step
		cls = @step_to_next_step[@current_wizard_step.class]
		return get_step(cls) if cls
	end

end
