require 'aml'

class WireframeEditorGridDialog < AML::Control

  attr_reader :config
  bindable_attr_writer :config

  def my_init
    self.config = @info['configuration']
    @info.before_close.add(lambda { before_close })

    grid_style = config.grid_style
    @line.selected = grid_style == GridStyle.lines

    @list.text = config.grid_size.width.to_i.to_s

    if (!config.SupportsDpi)
      @dpi_group_box.enabled = false
    else
      case config.document_base_d_p_i
        when 72: @seventy_two.selected = true
        when 96: @ninety_six.selected = true
        when 120: @one_twenty.selected = true
        else @other.selected = true
      end
    end
  end

  def dialog_info=(value)
    @info = value
    @info.set_fixed_size(AxSizeF.new(220, 250))
    my_init
  end

  def initialize()
    initialize_component('dialogs/wireframe/grid_dlg.aml')
  end

  def before_close
    config.grid_style = @line.selected ? GridStyle.lines : GridStyle.dots

    size = @list.text.to_i
    if (size < 5)
      size = 5
    end
    config.grid_size = AxSizeF.new(size, size)

    config.document_base_d_p_i = @seventy_two.selected ? 72 : @one_twenty.selected ? 120 : @other.selected ? @other_box.value.to_i : 96
  end

  def dpi_other_changed
    @other.selected = true
  end
end