require 'aml'

class CreateGuidesDialog < AML::Control

  attr_reader :config
  bindable_attr_writer :config

  def my_init
    self.config = @info['configuration']
    @info.set_fixed_size(AxSizeF.new(353,200))
  end

  def dialog_info=(value)
    @info = value

    my_init
  end

  def initialize()
    initialize_component('dialogs/wireframe/create_guides_dlg.aml')
  end

  def presets_select_list_select_index_changed(sender, e)

    if @presets_selectlist.selected_index == 0
      #960 12 col
      @number_cols.value = 12
      @col_width.value = 60
      @margin_left.value = 10
      @col_gutter.value = 20
    elsif @presets_selectlist.selected_index == 1
      #960 12 col
      @number_cols.value = 16
      @col_width.value = 40
      @margin_left.value = 10
      @col_gutter.value = 20
    end
 end

end