require 'aml'
require 'Core'
require 'Model'

include Axure::Client::DiagramEditing::ObjectEditors
include Axure::Linq::Collections
include Axure::DocumentModel
include Axure::DocumentModel::Objects

class EditTreeNode < AML::Control
  attr_reader :configuration
  bindable_attr_writer :configuration

  def my_init()
    self.configuration = @info["configuration"]
    @info.before_close.add(lambda { configuration.objects_to_edit = nodes_to_edit })
  end

  def dialog_info=(value)
    @info = value
    @info.set_fixed_size(AxSizeF.new(350,220))
    my_init()
  end

  def initialize()
    initialize_component('dialogs/tree/edit_tree_node.aml')
  end

  def nodes_to_edit
    root_objects = configuration.root_objects
    return root_objects if @this.selected
    return TreeNodeObject.GetSiblings(root_objects) if @siblings.selected
    return TreeNodeObject.GetSiblingsAndDescendants(root_objects) if @all.selected
  end

  def remove_button_clicked(sender, e)
    if @image.image_ref
      @image.image_ref = HashedImageRef.EmptyImage
      configuration.has_image_changed = true
    end
  end

  def import_button_clicked(sender, e)
    image = ImageFunctions.show_import_image_dialog()
    if image && image != @image.image_ref
      @image.image_ref = image
      configuration.has_image_changed = true
    end
  end
end