require 'aml'
require 'Model'

include Axure::Client::DiagramEditing::ObjectEditors
include Axure::DocumentModel

class EditTree < AML::Control
  attr_reader :configuration, :show_expand_collapse, :custom
  bindable_attr_writer :configuration

  def my_init()
    self.configuration = @info["configuration"]

    @image_stack.enabled = false
    set_initial_radio_button

    # this needs to happen here so that all of the necessary controls have been created
    @expand_images_radio_group.selected_control_changed.add(lambda { |sender, e| expand_images_changed(sender, e) })
  end

  def dialog_info=(value)
    @info = value
    @info.set_fixed_size(AxSizeF.new(470,195))
    my_init()
  end

  def initialize()
    initialize_component('dialogs/tree/edit_tree.aml')
  end

  def collapsed_remove_button_clicked(sender, e)
    @collapsed_image.image_ref = HashedImageRef.EmptyImage
  end

  def collapsed_import_button_clicked(sender, e)
    image = ImageFunctions.show_import_image_dialog()
    @collapsed_image.image_ref = image if image
  end

  def expanded_remove_button_clicked(sender, e)
    @expanded_image.image_ref = HashedImageRef.EmptyImage
  end

  def expanded_import_button_clicked(sender, e)
    image = ImageFunctions.show_import_image_dialog()
    @expanded_image.image_ref = image if image
  end

  def set_initial_radio_button
    if configuration.collapsed_image == plus_collapsed && configuration.expanded_image == plus_expanded
      @plus.selected = true
    elsif configuration.collapsed_image == arrow_collapsed && configuration.expanded_image == arrow_expanded
      @arrow.selected = true
    else @custom.selected = true
    end
  end

  def get_hashed_image_ref(i)
    ImageFunctions.get_hashed_image_ref_from_image(
            ImageListContainer.tree_node_image_list.images[i])
  end
  def plus_collapsed
    get_hashed_image_ref 0
  end
  def plus_expanded
    get_hashed_image_ref 1
  end
  def arrow_collapsed
    get_hashed_image_ref 2
  end
  def arrow_expanded
    get_hashed_image_ref 3
  end

  def expand_images_changed(sender, e)
    if @plus.selected
      @collapsed_image.image_ref = plus_collapsed
      @expanded_image.image_ref = plus_expanded
    elsif @arrow.selected
      @collapsed_image.image_ref = arrow_collapsed
      @expanded_image.image_ref = arrow_expanded
    end
  end
end