
require 'aml'

include Axure::Platform::WindowlessControls

class MyTest < WindowlessControl
  include AML
  extend AML::Bindable
  #extend AMLBindingProperties

  attr_reader :dialog_info
  bindable_attr_writer :dialog_info

  def initialize()
    #@dialog_info = info

    initialize_component('dialogs/my_test.aml')
    self.size = AxSize.new(400, 400)
    self.back_ground_fill = SolidFill.new(AxColor.purple)
  end

  def test__is_mouse_over_changed(sender, args)  
    f = SolidFill.new()

    if sender.is_mouse_over
      f.color = AxColor.Green
    else
      f.color = AxColor.light_blue
    end
    sender.back_ground_fill = f
    sender.invalidate
  end
end

def msg_box(text)
  Axure::Platform::AxPlatform.platform_services.show_message_box(text.to_s)
end

host = host_container.create_windowless_host(Axure::Platform::Drawing::AxSize.new(500,500), Axure::Platform::WindowlessControls::AxDockStyle::fill)
c = MyTest.new()
host.add_control(c)
c.dialog_info = info
c.dialog_info.other_text = "now is the time"
c.dialog_info = nil
info.other_text = "blah blah"
c.dialog_info = info

info.other_text = "22222"

