require 'aml'
require 'axure_enumerable'
require 'Model'
require 'interop'

require 'dialogs/team/wizard/team_step'

include Axure::Platform
include Axure::Platform::Controls

class TeamProjectNameWizardStep < TeamStep
	def initialize()
		super

		@show_next = true

		@description = intl_str("Enter a project name.")
		@title = intl_str("Shared Project Name")
	end

	def project_name_text_changed(s, e)
		self.can_next = is_valid_file_name(@project_name_textbox.text)
	end

	def verify
		return true
	end

	def wizard_control=(value)
		super(value)
		if wizard_control && wizard_control.dialog_info
			@project_name_textbox.text = wizard_control.dialog_info.get_property(TEAM_PROJECT_NAME_KEY)
		end
	end

	def save_step
		wizard_control.dialog_info.set_property(TEAM_PROJECT_NAME_KEY, @project_name_textbox.text)
	end

	def is_valid_file_name filename

		if (filename.index("\\") ||
				filename.index("/") ||
				filename.index(":") ||
				filename.index("*") ||
				filename.index("?") ||
				filename.index("<") ||
				filename.index(">") ||
				filename.index("|") ||
				filename.index("#") ||
				filename.index("$") )
			return false
		end

		return false if filename.strip().length == 0

=begin
		#TODO: 
		fullName = AxPlatform.PlatformServices.ApplicationFiles.RunningInstanceTemporaryPath + "\\" + filename + ".txt"
		begin
			fs = System::IO::File.Create(fullName)
			fs.Close()
			System::IO::File.Delete(fullName)
			return true
		rescue
		end
=end

		return true
	end

end
