require 'aml'
require 'dialogs/team/wizard/team_step'

include System::IO

include Axure::Platform
include Axure::Platform::CommonDialogs

include Axure::Client::Common::Team
include Axure::Client::Dialogs::Infos
include Axure::Client::Operations

class TeamLocalDirectoryWizardStep < TeamStep
	def initialize()
		super

		@show_previous = true
		@show_finish = true

		@title = intl_str("Local Directory for the Shared Project")
		@description = intl_str("Select a local directory for your copy of the Shared Project.");
		@help_label.text = intl_str(String.Format("The local directory is typically on a drive on your computer. This is the where your copy of the Shared Project will be created.\n"+
"Ex: {0}" + SEP + "MySharedProjects\n\n" +
"A folder will be created in this directory with the project name.\n" +
"Ex: {0}" + SEP + "MySharedProjects"+SEP+"ProjectName\n\n" +
"When working on the Shared Project, you will be editing this copy. To open the Shared Project, use File->Open and select the .rpprj file in the project directory.

The project will be opened automatically after creating the Shared Project.", Environment.GetFolderPath(Environment::SpecialFolder.Personal) ))
	end

	def local_directory_text_changed
		self.can_finish = @local_directory_textbox.text.strip().length > 0
	end

	def browse_clicked
		open_dir_dlg = AxOpenFolderDialogInfo.new 
		open_dir_dlg.description = intl_str("Select a local directory for your copy of the Shared Project.")
		
		if open_dir_dlg.show_dialog() == AxDialogResult.OK
    	@local_directory_textbox.text = open_dir_dlg.folder_name
		end
	end

	def wizard_control=(value)
		super value
		
		if wizard_control && wizard_control.dialog_info
			@local_directory_textbox.text = wizard_control.dialog_info.get_property(TEAM_LOCAL_DIRECTORY_KEY)
        end

        if (@local_directory_textbox.text.length == 0)
          @local_directory_textbox.text = AxPlatform.PlatformServices.GetDefaultSharedProjectsPath()
        end
	end

	def save_step
		wizard_control.dialog_info.set_property(TEAM_LOCAL_DIRECTORY_KEY, @local_directory_textbox.text)
	end
	

	def verify
		path = @local_directory_textbox.text;
		projectpath = path + SEP + wizard_control.dialog_info.get_property(TEAM_PROJECT_NAME_KEY)

		#Check if directory exists. If not create it.
		createdPath = false;

		begin
			localDi = DirectoryInfo.new(path);
		rescue StandardError, System::Exception 
			AxPlatform.ShowMessageBox(String.Format(intl_str("{0} is an invalid local directory.\nPlease select a directory on your computer."), path));
			return false
		end

		if !localDi.Exists 
			if AxPlatform.ShowMessageBox(
				String.Format(intl_str("{0} does not exist.\nWould you like to create it?"), path),
				intl_str("Alert"), AxMessageBoxButtons.YesNo) == AxDialogResult.Yes 

				begin
					Directory.CreateDirectory(path)
					createdPath = true
				rescue StandardError, System::Exception 
					AxPlatform.ShowMessageBox(String.Format(intl_str("{0} could not be created.\nPlease select another folder."), path))
					return false
				end
			else 
				return false
			end
		else 
			if TeamClientFunctions.CheckSharedFolderPath(path)
				AxPlatform.ShowMessageBox(
					String.Format(intl_str("{0} is in another shared project.\nPlease choose another path."), projectpath))
					return false
			end
		end #localDi.Exists

		if !createdPath && Directory.Exists(projectpath) 
			if Directory.GetDirectories(projectpath).Length != 0 || 
				Directory.GetFiles(projectpath).Length != 0
				#TODO: change checking reqs
				AxPlatform.ShowMessageBox(String.Format( 
					intl_str("{0} is not empty.\nThe local directory for a shared project must be empty."), projectpath))
				return false
			end
		else 
			begin
				Directory.CreateDirectory(projectpath)
			rescue StandardError, System::Exception 
				AxPlatform.ShowMessageBox(String.Format( intl_str(" could not be created.\nPlease select another folder."), projectpath))
				return false
			end
		end

		return true

	end
end
