
require 'aml'
require 'dialogs/team/wizard/team_step'

include Axure::Platform::CommonDialogs

include Axure::Client::Common::Team
include Axure::Client::Dialogs::Infos
include Axure::Client::Operations

class GetSharedDirectoryWizardStep < TeamStep
	def initialize()
		super

		@show_next = true
		@show_previous = false

		@title = intl_str("Shared Project Directory")
		@description = intl_str("Select the directory where the Shared Project is located.")

		@path_verified = false
	end

	def browse_clicked
		open_dir_dlg = AxOpenFolderDialogInfo.new 
		open_dir_dlg.description = intl_str("Select the directory containing the Shared Project.")
		if open_dir_dlg.show_dialog() == AxDialogResult.OK
    	@shared_directory_textbox.text = open_dir_dlg.folder_name
		end
	end

	def shared_directory_text_changed
		@path_verified = false
		self.can_next = @shared_directory_textbox.text.strip().length > 0
	end

	def wizard_control=(value)
		super(value)
		if wizard_control && wizard_control.dialog_info
			@shared_directory_textbox.text = wizard_control.dialog_info.get_property(TEAM_SHARED_DIRECTORY_KEY)
		end
	end

	def save_step
		wizard_control.dialog_info.set_property(TEAM_SHARED_DIRECTORY_KEY, @shared_directory_textbox.text)
	end

	def verify
		return true if @path_verified

		checkPathOp = TeamProjectOperation.new
		checkPathOp.CheckVersion = false
		checkPathOp.OperationName = intl_str("Checking paths . . . ")
		checkPathOp.Work.add(lambda { 
			@path_verified = checkPathOp_Work()
		})

		progressDialog = ProgressDialogInfo.new()
		progressDialog.TrapErrors = false
		progressDialog.Operation = checkPathOp
		progressDialog.SupportsCancel = false
		progressDialog.MarqueeStyle = true
		progressDialog.ShowDialog()

		return @path_verified
	end

  def checkPathOp_Work
		begin
			path = Axure::Platform::AxUri.new(@shared_directory_textbox.Text)
		rescue StandardError, System::Exception 
			AxPlatform.ShowMessageBox(@shared_directory_textbox.Text + intl_str(" is not a valid path."))
			return false
		end

		if TeamClientFunctions.CheckConnectionFromUri(path) 
			if !TeamClientFunctions.IsShareProject(path)
				if path.IsFile
					AxPlatform.ShowMessageBox(
						intl_str("This is not a valid shared project directory. Please select a new directory."))
				else
					AxPlatform.ShowMessageBox(
						intl_str("This is not a valid shared project location. Please select a new location."))
				end #IsFile
				return false
			end #IsShareProject
		else
			return false #!CheckConnection
		end #CheckConnection

		return true #CheckConnection && IsShareProject
	end
	
end
