require 'aml'
require 'axure_enumerable'
require 'Model'
require 'interop'
require 'set'

include Axure::Platform
include Axure::Platform::Controls

include Axure::Client::Operations
include Axure::Client::Common::Team

include Axure::DocumentModel


class ResolveLockDialog < AML::Control
	def initialize()
		self.auto_size = true
		initialize_component("dialogs/team/resolve_lock_dialog.aml")

		@control_to_guid = Hash.new
		@steal_lock_guids = Set.new

		STEAL_STR =   intl_str("Steal Check Out");
		DONOT_STEAL_STR =   intl_str("Do Not Check In");
	end

	def dialog_info=(_info)
		@dialog_info = _info

        _info.default_size = AxSizeF.new(500,300)
        _info.min_size = AxSizeF.new(500,250)
        _info.title = intl_str("Steal Check Outs")

		_info.before_close.add(lambda {|s, ce|
			if !@steal_lock_guids.empty?
				@dialog_info.set_property("OverrideLockRequests", @steal_lock_guids.to_clr_list)
			end
		})

		locked_pkgs = @dialog_info["LockedPackages"]
		locked_pkgs.each { | kvpair |
		 	package_info, lock_owner = kvpair.key, kvpair.value

			c = @packages_list.add_item(DONOT_STEAL_STR, package_info.package_name, lock_owner)
			@control_to_guid[c] = package_info.package_id
		}

	end

	def steal_clicked
		c =  @packages_list.selected_item
		if c
			c.get_control_at_index(0).text = STEAL_STR
			@steal_lock_guids.add(@control_to_guid[c])
		end
	end

	def donot_steal_clicked
		c =  @packages_list.selected_item
		if c
			c.get_control_at_index(0).text = DONOT_STEAL_STR
			@steal_lock_guids.delete(@control_to_guid[c])
		end
	end

	def donot_steal_any_clicked
		@steal_lock_guids = Set.new
		@packages_list.controls.each { | c |
			c.get_control_at_index(0).text = DONOT_STEAL_STR
		}
	end

	def steal_all_clicked
		@packages_list.controls.each { | c |
			c.get_control_at_index(0).text = STEAL_STR
		}
		@steal_lock_guids = @control_to_guid.values.to_set
	end
end
