require 'aml'
require 'axure_enumerable'
require 'Model'
require 'interop'
require 'set'

include Axure::Platform
include Axure::Platform::Controls

include Axure::Client::Operations
include Axure::Client::Common::Team

include Axure::DocumentModel


class ResolveConflictDialog < AML::Control
	def initialize()
		self.auto_size = true
		initialize_component("dialogs/team/resolve_conflict_dialog.aml")

		@control_to_guid = Hash.new
		@mine_guids = Set.new
		@shared_guids = Set.new

		MINE_STR =   intl_str("Use Mine");
		SHARED_STR =   intl_str("Use Shared");
	end

	def dialog_info=(_info)
		@dialog_info = _info

        _info.default_size = AxSizeF.new(500,300)
        _info.min_size = AxSizeF.new(500,250)
        _info.title = intl_str("Resolve Conflicts")

		_info.before_close.add(lambda {|s, ce|
			@dialog_info.set_property("UseMineRequest", @mine_guids.to_clr_list) if !@mine_guids.empty?
            latest = @control_to_guid.values.to_set.subtract(@mine_guids)
			@dialog_info.set_property("UseLatestRequest", latest.to_clr_list) if !latest.empty?
		})

		locked_pkgs = @dialog_info["ConflictPackages"]
		locked_pkgs.each { | kvpair |
		 	package_info, author = kvpair.key, kvpair.value

			c = @packages_list.add_item(MINE_STR, package_info.package_name, author)

			@control_to_guid[c] = package_info.package_id
			@mine_guids.add(package_info.package_id)
		}
	end

	def use_mine_clicked
		c =  @packages_list.selected_item
		if c
			c.get_control_at_index(0).text = MINE_STR
			@mine_guids.add(@control_to_guid[c])
		end
	end

	def use_shared_clicked
		c =  @packages_list.selected_item
		if c
			c.get_control_at_index(0).text = SHARED_STR
			@mine_guids.delete(@control_to_guid[c])
		end
	end

	def use_shared_all_clicked
		@mine_guids = Set.new
		@packages_list.controls.each { | c |
			c.get_control_at_index(0).text = SHARED_STR
		}
	end

	def use_mine_all_clicked
		@packages_list.controls.each { | c |
			c.get_control_at_index(0).text = MINE_STR
		}
		@mine_guids = @control_to_guid.values.to_set
	end
end
