require 'aml'

include Axure::Platform
include Axure::Platform::CommonDialogs
include Axure::Platform::Controls

include Axure::Client::Dialogs::Infos
include Axure::Client::Common::Team
include Axure::Client::Operations

class TeamRelocateSharedDirectoryDialog < AML::Control
	def initialize()
		self.auto_size = true
		initialize_component("dialogs/team/relocate_shared_directory.aml")
	end

	def dialog_info=(info)
        info.default_size = AxSizeF.new(400,90)
        info.min_size = AxSizeF.new(300,80)

		info.before_close.add(lambda {|s, ce| 
    	info["SharedDirectory"] = @shared_directory_textbox.text

			ce.handled = !verify if(info.dialog_result == AxDialogResult.OK) 
		})

    @shared_directory_textbox.text = info["SharedDirectory"]
	end

	def browse_clicked
		open_dir_dlg = AxOpenFolderDialogInfo.new 
		open_dir_dlg.description = intl_str("Select the directory that contains the Shared Project.")
		if open_dir_dlg.show_dialog() == AxDialogResult.OK
    	@shared_directory_textbox.text = open_dir_dlg.folder_name
		end
	end

	def verify
		ret_val = false

		checkPathOp = TeamProjectOperation.new
		checkPathOp.CheckVersion = false
		checkPathOp.OperationName = intl_str("Checking paths . . . ")
		checkPathOp.Work.add(lambda { 
			ret_val = checkPathOp_Work()
		})

		progressDialog = ProgressDialogInfo.new()
		progressDialog.TrapErrors = false
		progressDialog.Operation = checkPathOp
		progressDialog.SupportsCancel = false
		progressDialog.MarqueeStyle = true
		progressDialog.ShowDialog()

		return ret_val
	end


  def checkPathOp_Work
		begin
			path = Axure::Platform::AxUri.new(@shared_directory_textbox.Text)
		rescue StandardError, System::Exception 
			AxPlatform.ShowMessageBox(@shared_directory_textbox.Text + intl_str(" is not a valid path."))
			return false
		end

		if TeamClientFunctions.CheckConnectionFromUri(path) 
			if !TeamClientFunctions.IsShareProject(path)
				if path.IsFile
					AxPlatform.ShowMessageBox(
						intl_str("This is not a valid shared project directory. Please select a new directory."))
				else
					AxPlatform.ShowMessageBox(
						intl_str("This is not a valid shared project location. Please select a new location."))
				end #IsFile
				return false
			end #IsShareProject
		else
			return false #!CheckConnection
		end #CheckConnection

		return true #CheckConnection && IsShareProject
	end
end
