require 'aml'
require 'axure_enumerable'
require 'Model'
require 'interop'

include Axure::Platform
include Axure::Platform::Controls

include Axure::Client::Operations
include Axure::Client::Common::Team

include Axure::DocumentModel
include Axure::Platform::Storage::RevisionTracking


class TeamProjectHistoryBrowser < AML::Control
	def initialize()
		self.auto_size = true
		initialize_component("dialogs/team/project_history_browser.aml")
	end

	def dialog_info=(_info)
		@client = _info.get_property("Client");
		@shared_folder_textbox.text = _info.get_property("CurrentSharedFolder");
        @start_date_chooser.Value = System::DateTime.Today.Subtract(System::TimeSpan.FromDays(7));
        @end_date_chooser.Value = System::DateTime.Today;
        @export_button.Enabled = false;

		@dialog_info = _info

        _info.default_size = AxSizeF.new(560,500)
        _info.min_size = AxSizeF.new(560,400)
        _info.title = intl_str("Shared Project History Browser")

        _info.before_shown.add(lambda {
          @log_list.set_widths_proportional
          @log_list.set_column_comparer(1, SortTypes.date_as_string)
        })
	end

    def set_history(histories)
        histories.each { |h|
            check_in_notes = h.Comment.gsub("<AXCHECKIN>", "").gsub("</AXCHECKIN>", "")
            @rev_to_notes[h.RevisionTag] = check_in_notes

            oneline = check_in_notes.gsub("\r\n", " ")
            oneline = oneline.gsub("\n", " ")
            @log_list.add_item(h.RevisionTag, h.EntryTime.to_s, h.User, oneline)
        }
    end

	def get_history_button_click(s, e)
		#get_history("1", "HEAD")
        @rev_to_notes = Hash.new

        @log_list.clear_controls();
        @export_button.Enabled = false;

        if (@all_dates_check_button.selected)
            start_rev =   "1";
            end_rev = RevisionTag.Head;
        else
            start_rev = @start_date_chooser.Value.ToUniversalTime().ToString()
            end_rev = @end_date_chooser.Value.AddDays(1).ToUniversalTime().ToString()
        end

        get_history(start_rev, end_rev);
	end

    def export_button_clicked
		#revisionInfo = ""
		rev = ""

		item = @log_list.selected_item

		return if !item

		rev = item.get_control_at_index(0).text
        return if (rev.strip().length == 0)

		#date_text = item.get_control_at_index(1).text
		#author_text = item.get_control_at_index(2).text
		#revisionInfo = String.Format(intl_str("Revision: {0} ({1}) by {2}"), rev, date_text, author_text)

		share_folder_uri = AxUri.new(@shared_folder_textbox.text);

        if (@client.FileSavingManager.ExportSharedProject(@client, share_folder_uri, rev))
          @dialog_info.click_ok #close
        end

#		success, rp_filename = TeamClientFunctions.ExportProjectToRPFile(@client, share_folder_uri, rev)
#
#		if (success)
#			if (AxPlatform.ShowMessageBox(
#				String.Format( intl_str("Do you want to open the exported file?\r\n{0}"), rp_filename), "", AxMessageBoxButtons.YesNo) == AxDialogResult.Yes)
#              @client.OpenDocument(rp_filename);
#              @dialog_info.click_ok #close
#			end
#		end

    end

    def log_selected_index_changed(s, e)
        item = @log_list.selected_item
        if !item
          @export_button.Enabled = false
          return
        end

		rev = @log_list.selected_item.get_control_at_index(0).text
		@notes_text_box.text = @rev_to_notes[rev]

        @export_button.Enabled = true;
	end

    def next_100_button_clicked(s, e)
        control_count = @log_list.get_control_count()
        if (control_count == 0)
        		@rev_to_notes = Hash.new
            get_history("1","Head")
        else
            end_rev = @log_list.get_control_at_index(control_count - 1).get_control_at_index(0).text
            if (end_rev == "1")
                @next_100_button.Enabled = false
            else
                end_rev = (end_rev.to_i - 1).to_s
                start_rev = (end_rev.to_i - 99).to_s
                if (start_rev.to_i < 1)
                    start_rev = "1"
                    @next_100_button.Enabled = false
                end
                get_history(start_rev, end_rev)
            end
        end

        #if (@log_list.get_control_count() > 0)
            #@log_list.Items[@log_list.get_control_count() - 1].EnsureVisible();
        #end
    end

    def get_history(start_rev, end_rev)
		begin
			shareFolderUri = AxUri.new(@shared_folder_textbox.text);
		rescue StandardError, System::Exception
			AxPlatform.ShowMessageBox(intl_str("The shared directory is not valid.\r\nPlease try again."), intl_str("Alert"));
		end

        return if (!shareFolderUri)
        return if (!TeamClientFunctions.CheckConnection(@client, shareFolderUri))

        histOp = TeamProjectOperation.new
        histOp.CheckVersion = false
        histOp.File = @client.CurrentFile
        histOp.OperationName =   intl_str("Getting History")

		histOp.Work.add(lambda {
			histories = @client.CurrentFile.Team.GetProjectHistory(shareFolderUri, start_rev, end_rev);
			set_history(histories)
		})

		progressDialog = Axure::Client::Dialogs::Infos::ProgressDialogInfo.new
		progressDialog.Operation = histOp
		progressDialog.SupportsCancel = false
		progressDialog.MarqueeStyle = true
		progressDialog.ShowDialog()

		if (@log_list.get_control_count() != 0)
            end_rev = @log_list.get_control_at_index(@log_list.get_control_count() - 1).get_control_at_index(0).text
 			if (end_rev ==   "1")
				@next_100_button.Enabled = false
			else
				@next_100_button.Enabled = true
			end
		else
			@next_100_button.Enabled = false
		end

#    AxPlatform.ShowMessageBox(  intl_str("Getting History failed.\nPlease check the shared folder location and try again."));

	end

    def file_browse_button_clicked(sender, args)
        open_dialog = Axure::Platform::CommonDialogs::AxOpenFolderDialogInfo.new
        open_dialog.description = intl_str("Select the shared directory.")

        @shared_folder_textbox.text = open_dialog.folder_name if open_dialog.show_dialog == AxDialogResult.o_k
    end

    def shared_folder_textbox_text_changed(s, e)
        if (@shared_folder_textbox.Text.Length > 0)
            @next_100_button.Enabled = true;
            @get_history_button.Enabled = true;
        else
            @next_100_button.Enabled = false;
            @get_history_button.Enabled = false;
        end
    end

    def all_dates_check_button_selected_changed(s, e)
        if (@all_dates_check_button.selected)
            @start_date_chooser.Enabled = false;
            @end_date_chooser.Enabled = false;
        else
            @start_date_chooser.Enabled = true;
            @end_date_chooser.Enabled = true;
        end
    end

    def close_button_clicked(s, e)
        @dialog_info.click_ok
    end

end
