require 'aml'
require 'axure_enumerable'
require 'Model'
require 'interop'
require 'set'

include Axure::Platform
include Axure::Platform::Controls

include Axure::Client::Operations
include Axure::Client::Common::Team

include Axure::DocumentModel


class CheckOutErrorDialog < AML::Control
	def initialize()
		self.auto_size = true
		initialize_component("dialogs/team/check_out_error_dialog.aml")

		DO_NOT_EDIT_STR = intl_str("Do Not Edit")
		EDIT_WO_CHECKOUT_STR = intl_str("Edit w/o Check Out")

		@control_to_guid = Hash.new
		@unsafe_lock_guids = Set.new
	end

	def dialog_info=(_info)
		@dialog_info = _info

        _info.default_size = AxSizeF.new(500,300)
        _info.min_size = AxSizeF.new(500,250)
        _info.title = intl_str("Unable to Check Out")

		_info.before_close.add(lambda {|s, ce|
			if !@unsafe_lock_guids.empty?
				@dialog_info.set_property("UnsafeLockRequests", @unsafe_lock_guids.to_clr_list)
			end
		})

		connection_error =  @dialog_info["ConnectionError"]
		if !connection_error
			@packages_list = GridListPanel.new
			@packages_list.set_attached_property(GridListPanel.COLUMN, 0)
			@packages_list.header = [intl_str('Action'),
				intl_str('Page/Master/Property'),
				intl_str('Checked out by')].to_clr_list

			@grid.add_control(@packages_list)

            @warning_label.text = intl_str('The following pages or masters are already checked out.')
		end

		locked_pkgs = @dialog_info["LockedPackages"]
		locked_pkgs.each { | kvpair |
		 	package_info, lock_owner = kvpair.key, kvpair.value

			if connection_error
				c = @packages_list.add_item(DO_NOT_EDIT_STR, package_info.package_name)
			else
				c = @packages_list.add_item(DO_NOT_EDIT_STR, package_info.package_name, lock_owner)
			end
			@control_to_guid[c] = package_info.package_id
		}

	end

	def donotedit_clicked
		c =  @packages_list.selected_item
		if c
			c.get_control_at_index(0).text = DO_NOT_EDIT_STR
			@unsafe_lock_guids.delete(@control_to_guid[c])
		end
	end

	def edit_wo_checkout_clicked
		c =  @packages_list.selected_item
		if c
			c.get_control_at_index(0).text = EDIT_WO_CHECKOUT_STR
			@unsafe_lock_guids.add(@control_to_guid[c])
		end
	end

	def donotedit_all_clicked
		@unsafe_lock_guids = Set.new
		@packages_list.controls.each { | c |
			c.get_control_at_index(0).text = DO_NOT_EDIT_STR
		}
	end

	def edit_all_clicked
		@packages_list.controls.each { | c |
			c.get_control_at_index(0).text = EDIT_WO_CHECKOUT_STR
		}
		@unsafe_lock_guids = @control_to_guid.values.to_set
	end
end
