require 'aml'
require 'axure_enumerable'
require 'Model'
require 'interop'

include Axure::DocumentModel
include Axure::Platform::Controls

class CheckInLogDialog < AML::Control
	def initialize()
		self.auto_size = true
		initialize_component("dialogs/team/check_in_log.aml")
	end

	def dialog_info=(_info)
		@info = _info
		#TODO: change title
		if _info.send_changes
			@notes_label.text = intl_str("Change notes:")
			@message_label.text = intl_str("Changes from following pages, masters, and project properties are being sent to the shared folder.")
		end

		if _info.has_changes
				@notes_text_box.text = _info.check_in_log_message if _info.check_in_log_message
		else
			if _info.send_changes
				@notes_text_box.text =
					intl_str("No changes have been made. The change notes will not be saved.")
			else
				@notes_text_box.text =
					intl_str("No changes have been made. The check in notes will not be saved.")
			end
			@notes_text_box.enabled = false
		end

		_info.before_close.add(lambda {|s, ce| before_close(s, ce)})

        _info.default_size = AxSizeF.new(400,400)
        _info.min_size = AxSizeF.new(300,300)

        @summary_grid.set_column_width(1,250)
		do_summary_grid
	end

	def do_summary_grid
		noAction = @info["noAction"]
		useLatest = @info["useLatest"]
		useMine = @info["useMine"]
		deps = @info["deps"]
		dDocSyncReport = @info["dDocSync"]

    action = @info.send_changes ?  intl_str("Send changes") : intl_str("Check in")

		@summary_grid.add_item(action, intl_str("DPI Setting change")) if dDocSyncReport.DPIModified
        @summary_grid.add_item(action, intl_str("Global Guides change")) if dDocSyncReport.GuidesModified
		@summary_grid.add_item(action, intl_str("Sitemap changes")) if dDocSyncReport.SitemapModified
		@summary_grid.add_item(action, intl_str("Master List changes")) if dDocSyncReport.MasterListModified
		@summary_grid.add_item(action, intl_str("Generator List changes")) if dDocSyncReport.GeneratorListModified

		noAction.each { |pkgInfo|
			@summary_grid.add_item(action, pkgInfo.PackageName )
		}

    useLatest.each { |pkgInfo|
			@summary_grid.add_item(intl_str("Use shared"), pkgInfo.PackageName )
    }

    useMine.each { |pkgInfo|
			@summary_grid.add_item(intl_str("Use mine"), pkgInfo.PackageName )
    }

		has_deps = false
		deps.each { |pkgInfo|
			#dependecies are always to be check in
			#because they are new pkgs
			@summary_grid.add_item(intl_str("Check in"), pkgInfo.PackageName )
			has_deps = true
		}

		if has_deps && @info.send_changes
			dependencyLabel = AxLabel.new
    	#dependencyLabel.set_attached_property(GridLayoutPanel.ROW, 1)
			dependencyLabel.text = intl_str("NOTE: Some pages or masters will be checked in to complete this action.")

			@grid.add_control(dependencyLabel)
		end


		dDocSyncReport.DeletedPackageInfos.each { |pkgInfo|
			@summary_grid.add_item(intl_str("Deleted"), pkgInfo.PackageName )
		}

	end

	def before_close(s, ce)
		@info.check_in_log_message = @notes_text_box.text
	end
end
