require 'aml'
require 'axure_enumerable'
require 'Model'
require 'interop'

include Axure::DocumentModel
include Axure::Platform::Controls

class AdditionalCheckOutRequestDialog < AML::Control
	def initialize()
		self.auto_size = true
		initialize_component("dialogs/team/additional_checkout_request.aml")

		@control_to_guid = Hash.new
	end

	def dialog_info=(info)
		@dialog_info = info

        info.default_size = AxSizeF.new(300,300)
        info.min_size = AxSizeF.new(300,300)
        info.title = intl_str("Check Out Request")

		@dialog_info.before_close.add(lambda {|s, ce| before_close(s, ce)})

		@has_option = @dialog_info["UserHasOptions"]
		@pkg_infos = @dialog_info["PackageInfos"]

		#@dialog_info.cancel_visible = !@has_option

		@grid.remove_control(@buttons) if !@has_option

		@pkg_infos.each { |p_info|
			c = @has_option ? AxCheckButton.new : AxLabel.new
			c.text = p_info.package_name
			@control_to_guid[c] = p_info.package_id

			@package_list.add_item(c)
		}

	end

	def before_close(s, ce)
		if !@has_option
			@dialog_info["CheckOutRequest"] = @control_to_guid.values.to_clr_list
			return
		end

		retval = []
		@package_list.controls.each { | c |
			retval << @control_to_guid[c]if c.selected
		}

		@dialog_info["CheckOutRequest"] = retval.empty? ? List.of(System::Guid).new() : retval.to_clr_list
	end

	def unselect_clicked
		@package_list.controls.each { | c |
			c.selected = false
		}
	end

	def select_clicked
		@package_list.controls.each { | c |
			c.selected = true
		}
	end
end
