require 'aml'
require 'axure_enumerable'
require 'Model'

include Axure::Platform::Controls

include Axure::Client::Interaction
include Axure::Client::WindowlessControls

include Axure::DocumentModel
include Axure::DocumentModel::Interaction

class TablePropertiesDialog < AML::Control
	def initialize()
		initialize_component('dialogs/table_properties_dlg/table_properties_dlg.aml')
	end

	def dialog_info=(_info)
        @dialog_info = _info
        _info.set_fixed_size(AxSizeF.new(220,37))

        @rows_numberbox.Value = 3
        @cols_numberbox.Value = 3

        _info.before_shown.add(lambda{@rows_numberbox.focus; @rows_numberbox.select_all})
	end

    def rows_numberbox_valuechanged(sender, event_args)
        @dialog_info.rows = @rows_numberbox.Value
    end

    def cols_numberbox_valuechanged(sender, event_args)
        @dialog_info.columns = @cols_numberbox.Value
    end
end
