require 'aml'
require 'dialogs/interaction_editor_dlg/link_editor'

include Axure::Client::ToolBoxes::Components::PagesAndMasters

class ReferencePageDialog < AML::Control
  def initialize()
    initialize_component("dialogs/reference_page_dialog.aml")
    self.size = AxSize.new(300, 400)
  end

  def dialog_info=(_info)
    @info = _info
    @info.title = intl_str("Reference Page")

    @info.default_size = AxSizeF.new(300, 300)
    @info.min_size = AxSizeF.new(250, 200)

    @page_treeview.current_document = @info.sitemap.parent_document
    @page_treeview.current_tree_map = @info.sitemap
    @page_treeview.current_package_id = @info.select_page_package_id
  end

  def page_treeview_current_node_changed(sender, event_args)
#    return if !@page_treeview.current_node

    @info.select_page_package_id = @page_treeview.current_package_id
  end

  def clear_reference_clicked(s, e)
    @page_treeview.current_node = nil
#    @info.select_page_package_id = System::Guid.Empty()
  end
end
